/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.recipe.oven;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.renyigesai.bakeries.recipe.oven.AbstractOvenRecipe;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class OvenRecipe
extends AbstractOvenRecipe {
    public OvenRecipe(ResourceLocation id, ItemStack output, int time, int min_temperature, int max_temperature, int perfect_temperature, Ingredient recipeItems) {
        super(Type.INSTANCE, Serializer.INSTANCE, id, output, time, min_temperature, max_temperature, perfect_temperature, recipeItems);
    }

    public static class Type
    implements RecipeType<OvenRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "oven";

        private Type() {
        }
    }

    public static class Serializer<T extends AbstractOvenRecipe>
    implements RecipeSerializer<T> {
        public static final Serializer INSTANCE = new Serializer<OvenRecipe>(OvenRecipe::new);
        public static final ResourceLocation ID = new ResourceLocation("bakeries", "oven");
        private final CookieBaker<T> factory;

        private Serializer(CookieBaker<T> pFactory) {
            this.factory = pFactory;
        }

        @NotNull
        public T fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            int time = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"time");
            int min_temperature = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"min_temperature");
            int max_temperature = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"max_temperature");
            int perfect_temperature = -1;
            if (pSerializedRecipe.has("perfect_temperature")) {
                perfect_temperature = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"perfect_temperature");
            }
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pSerializedRecipe, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonelement, (boolean)false);
            return this.factory.create(pRecipeId, output, time, min_temperature, max_temperature, perfect_temperature, ingredient);
        }

        @Nullable
        public T fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf buf) {
            int time = buf.readInt();
            int min_temperature = buf.readInt();
            int max_temperature = buf.readInt();
            int perfect_temperature = buf.readInt();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            if (perfect_temperature != -1) {
                return this.factory.create(pRecipeId, output, time, min_temperature, max_temperature, perfect_temperature, ingredient);
            }
            return this.factory.create(pRecipeId, output, time, min_temperature, max_temperature, -1, ingredient);
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            buf.writeInt(((AbstractOvenRecipe)recipe).time);
            buf.writeInt(((AbstractOvenRecipe)recipe).min_temperature);
            buf.writeInt(((AbstractOvenRecipe)recipe).max_temperature);
            buf.writeInt(((AbstractOvenRecipe)recipe).m_7527_().size());
            for (Ingredient ing : ((AbstractOvenRecipe)recipe).m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(((AbstractOvenRecipe)recipe).m_8043_(null), false);
        }

        static interface CookieBaker<T extends AbstractOvenRecipe> {
            public T create(ResourceLocation var1, ItemStack var2, int var3, int var4, int var5, int var6, Ingredient var7);
        }
    }
}

