/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.item;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.bakeries.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CakeRollItem
extends Item {
    public CakeRollItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        this.addEffects(pLevel, pStack, pLivingEntity);
        return super.m_5922_(pStack, pLevel, pLivingEntity);
    }

    public static List<ItemStack> getInventoryList(ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("Inventory", 10)) {
            ItemStackHandler handler = new ItemStackHandler(4);
            handler.deserializeNBT(tag.m_128469_("Inventory"));
            for (int i = 0; i < handler.getSlots(); ++i) {
                stacks.add(handler.getStackInSlot(i));
            }
        }
        return stacks;
    }

    public void addEffects(Level level, ItemStack stack, LivingEntity entity) {
        List<ItemStack> inventoryList = CakeRollItem.getInventoryList(stack);
        if (inventoryList.isEmpty()) {
            return;
        }
        for (ItemStack iStack : inventoryList) {
            if (iStack.m_41619_() || !iStack.m_41720_().m_41472_()) continue;
            List effects = Objects.requireNonNull(new ItemStack((ItemLike)iStack.m_41720_()).getFoodProperties(entity)).m_38749_();
            for (Pair effect : effects) {
                if (level.f_46443_ || effect.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)effect.getSecond()).floatValue())) continue;
                entity.m_7292_(new MobEffectInstance((MobEffectInstance)effect.getFirst()));
            }
        }
    }

    public static void setName(ItemStack stack) {
        List<ItemStack> inventoryList = CakeRollItem.getInventoryList(stack);
        StringBuilder strings = new StringBuilder();
        for (ItemStack iStack : inventoryList) {
            if (iStack.m_41619_()) continue;
            strings.append(iStack.m_41720_().m_7626_(iStack).getString());
        }
        strings.append(stack.m_41720_().m_7626_(stack).getString());
        stack.m_41714_(Component.m_130674_((String)String.valueOf(strings)));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag isAdvanced) {
        List<ItemStack> inventoryList = CakeRollItem.getInventoryList(stack);
        for (ItemStack itemStack : inventoryList) {
            TextUtils.addFoodEffectTooltip(itemStack, tooltip, 1.0f);
        }
        TextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
    }
}

