/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.inventory.blender;

import com.renyigesai.bakeries.block.blender.BlenderBlockEntity;
import com.renyigesai.bakeries.init.BakeriesMenuType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlenderMenu
extends AbstractContainerMenu {
    private final BlenderBlockEntity blockEntity;
    private final Player player;
    private final IItemHandler playerInventory;
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(10);

    public BlenderMenu(int windowId, Inventory playerInventory, BlenderBlockEntity blockEntity) {
        super((MenuType)BakeriesMenuType.BLENDER_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.player = playerInventory.f_35978_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        int ix = 61;
        int iy = 16;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotIndex = y * 3 + x;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), slotIndex, ix + x * 18 + 1, iy + y * 18 + 1));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 9, 152, 53));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 10, 152, 17));
        int fx = 8;
        int fy = 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotIndex = y * 3 + x;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getFiltrationinventory(), slotIndex, fx + x * 8, fy + y * 17));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getFiltrationinventory(), 9, 32, 52));
        this.addPlayerSlots(8, 84);
    }

    public static BlenderMenu create(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(pos);
        if (blockEntity instanceof BlenderBlockEntity) {
            return new BlenderMenu(windowId, playerInventory, (BlenderBlockEntity)blockEntity);
        }
        throw new IllegalStateException("Block entity is not an BlenderCoolerBlockEntity!");
    }

    protected void addPlayerSlots(int x, int y) {
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_((Slot)new SlotItemHandler(this.playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_((Slot)new SlotItemHandler(this.playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        ItemStack insert;
        if (pSlotId < 11 || pSlotId >= 21) {
            super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
            return;
        }
        if (pClickType == ClickType.THROW) {
            return;
        }
        ItemStack held = this.m_142621_();
        if (pClickType == ClickType.CLONE) {
            if (this.player.m_7500_() && held.m_41619_()) {
                ItemStack stackInSlot = ((Slot)this.f_38839_.get(pSlotId)).m_7993_().m_41777_();
                stackInSlot.m_41764_(1);
                this.m_142503_(stackInSlot);
                return;
            }
            return;
        }
        if (held.m_41619_()) {
            insert = ItemStack.f_41583_;
        } else {
            insert = held.m_41777_();
            insert.m_41764_(1);
        }
        ((Slot)this.f_38839_.get(pSlotId)).m_5852_(insert);
        this.m_38853_(pSlotId).m_6654_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            originalStack = stackInSlot.m_41777_();
            if (slotIndex < 11 ? !this.m_38903_(stackInSlot, 21, 56, false) : !this.m_38903_(stackInSlot, 0, 11, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == originalStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return originalStack;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.m_6542_(player);
    }

    public BlenderBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

