/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec;

import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.ItemAmount;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class FluidRecSerializerManager<R extends Recipe<? extends Container>>
extends RecSerializerManager<R> {
    protected Map<Fluid, List<ItemStack>> fluidContainers = new HashMap<Fluid, List<ItemStack>>();

    protected FluidRecSerializerManager(RecipeType<R> recipeType) {
        super(recipeType);
    }

    public List<ItemStack> fluidContainer(Fluid fluid) {
        return this.fluidContainers.getOrDefault(fluid, Collections.emptyList());
    }

    @Override
    protected abstract FluidRecipeInfoProvider<R> createRecipeInfoProvider();

    @Override
    protected void initRecs(Level level) {
        this.initFluidRecs(level);
    }

    protected abstract void initFluidRecs(Level var1);

    @Override
    protected List<MaidRec> recProcess(MKRecipe<R> r, Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        int recAmount;
        ItemDefinition fluidItemAmount = this.processRecFluids(available, invIngredient, single, itemTimes, r.inFluids());
        if (fluidItemAmount == null) {
            return Collections.emptyList();
        }
        boolean processRecIngres = super.processRecIngres(r, available, invIngredient, single, itemTimes);
        if (!processRecIngres) {
            return Collections.emptyList();
        }
        ItemStack result = r.output();
        ArrayList<MaidItem> maidItems = new ArrayList<MaidItem>();
        int amount = recAmount = this.getMaxAmount(available, single, itemTimes);
        if (single[0] || r.isSingle()) {
            amount = 1;
        }
        for (ItemDefinition item : invIngredient) {
            int minAmount = itemTimes.get(item).getAmount();
            int count = amount * minAmount;
            maidItems.add(new MaidItem(item, count));
            available.merge(item, Long.valueOf(count), (a, b) -> a - b);
        }
        MaidItem fluidItem = (MaidItem)maidItems.remove(0);
        MaidRec maidRec = new MaidRec((Recipe<?>)r.rec(), result, amount, (List<MaidItem>)maidItems, fluidItem);
        return this.generateRecs(maidRec, recAmount);
    }

    protected ItemDefinition processRecFluids(Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes, List<ItemStack> inFluids) {
        for (ItemStack inFluid : inFluids) {
            for (Map.Entry<ItemDefinition, Long> entry : available.entrySet()) {
                int amount;
                ItemDefinition key = entry.getKey();
                Item item = key.item();
                ItemStack stack = key.stack();
                if (!inFluid.m_150930_(stack.m_41720_()) || available.get(key) < (long)inFluid.m_41613_()) continue;
                invIngredient.add(key);
                if (stack.m_41741_() == 1) {
                    single[0] = true;
                    ItemAmount itemAmount = new ItemAmount(inFluid.m_41613_(), 1);
                    itemTimes.put(key, itemAmount);
                    amount = itemAmount.needCount();
                } else {
                    ItemAmount itemAmount = itemTimes.computeIfAbsent(key, k -> {
                        ItemAmount itemAmount1 = new ItemAmount(inFluid.m_41613_(), 1);
                        return itemAmount1;
                    });
                    amount = itemAmount.needCount();
                }
                if (entry.getValue() < (long)amount) {
                    return null;
                }
                return key;
            }
        }
        return null;
    }

    protected void queryItemFluids(Map<Fluid, List<Pair<ItemStack, Integer>>> fluidItems1, Map<Fluid, List<ItemStack>> fluidContainers1) {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack container;
            ItemStack defaultInstance;
            IFluidHandlerItem iFluidHandlerItem;
            if (this.modFluidItem(item, fluidItems1, fluidContainers1) || !((iFluidHandlerItem = (IFluidHandlerItem)(defaultInstance = item.m_7968_().m_41777_()).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)) instanceof FluidBucketWrapper)) continue;
            FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
            FluidStack fluidStack = fluidBucketWrapper.getFluid();
            Fluid rawFluid = fluidStack.getRawFluid();
            if (fluidStack.isEmpty() || rawFluid instanceof EmptyFluid) continue;
            if (fluidItems1.containsKey(rawFluid)) {
                List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(defaultInstance.m_41720_()))) {
                    fluidItems1.get(rawFluid).add((Pair<ItemStack, Integer>)Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount()));
                }
            } else {
                fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount())}));
            }
            if ((container = fluidBucketWrapper.getContainer().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers1.containsKey(rawFluid)) {
                List itemStacks = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                if (!itemStacks.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks.add(container);
                continue;
            }
            fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
    }

    protected boolean modFluidItem(Item item, Map<Fluid, List<Pair<ItemStack, Integer>>> fluidItems1, Map<Fluid, List<ItemStack>> fluidContainers1) {
        return false;
    }

    protected void queryRegistryFluids(Map<Fluid, List<ItemStack>> fluidContainers0) {
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            ItemStack container;
            if (fluid instanceof EmptyFluid || (container = fluid.m_6859_().m_7968_().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers0.containsKey(fluid)) {
                List<ItemStack> itemStacks = fluidContainers0.getOrDefault(fluid, Collections.emptyList());
                if (!this.isItem(itemStacks, container)) continue;
                itemStacks.add(container);
                continue;
            }
            fluidContainers0.put(fluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
    }

    public static abstract class FluidRecipeInfoProvider<R extends Recipe<? extends Container>>
    extends RecSerializerManager.RecipeInfoProvider<R> {
        @Override
        public ItemStack getContainer(RecSerializerManager<R> rsm, R rec) {
            Fluid outputFluid = this.getOutputFluid(rsm, rec);
            FluidRecSerializerManager rsm1 = (FluidRecSerializerManager)rsm.to();
            List stacks = rsm1.fluidContainers.getOrDefault(outputFluid, Collections.emptyList());
            return stacks.isEmpty() ? ItemStack.f_41583_ : (ItemStack)stacks.get(0);
        }

        public abstract Fluid getOutputFluid(RecSerializerManager<R> var1, R var2);

        @Override
        public boolean isSingle(RecSerializerManager<R> rsm, R rec) {
            return true;
        }
    }
}

