/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.chest;

import com.github.wallev.maidsoulkitchen.task.cook.common.inv.chest.ChestInvsData;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.util.WrapperItemHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class ChestInventory {
    public static final int TICK_SCAN_LIMIT = 10;
    public static final Codec<ChestInventory> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)BlockPos.f_121852_.listOf().fieldOf("chestPoses").forGetter(o -> o.chestPoses), (App)ItemInventory.CODEC.fieldOf("itemInventory").forGetter(o -> o.itemInventory)).apply((Applicative)ins, ChestInventory::new));
    private final List<BlockPos> chestPoses;
    private final List<BlockEntity> chestBes;
    private final List<IItemHandler> chestItemHandlers;
    private final ItemInventory itemInventory;
    private WrapperItemHandler allItemHandlers;
    private int slots = 0;
    private int lastSlot = 0;
    private long lastTime = 0L;

    private ChestInventory(List<BlockPos> chestPoses, ItemInventory itemInventory) {
        this.chestPoses = chestPoses;
        this.chestBes = new ArrayList<BlockEntity>();
        this.chestItemHandlers = new ArrayList<IItemHandler>();
        this.itemInventory = itemInventory;
        this.reset();
    }

    public ChestInventory() {
        this(new ArrayList<BlockPos>(), new ItemInventory());
    }

    public void init(ChestInvsData data) {
        this.initData(data);
    }

    public boolean needReUpdate() {
        return true;
    }

    public boolean tickScan() {
        for (int i = 0; i < 10; ++i) {
            if (this.lastSlot >= this.slots) {
                return true;
            }
            ItemStack stackInSlot = this.allItemHandlers.getStackInSlot(this.lastSlot);
            if (stackInSlot.m_41619_()) {
                ++this.lastSlot;
                continue;
            }
            this.itemInventory.add(stackInSlot);
            ++this.lastSlot;
        }
        return false;
    }

    public void update() {
        this.itemInventory.markDirty();
        this.itemInventory.update();
    }

    protected void reset() {
        this.chestBes.clear();
        this.chestItemHandlers.clear();
        this.allItemHandlers = null;
        this.slots = 0;
        this.lastSlot = 0;
    }

    public void clear() {
        this.reset();
        this.chestPoses.clear();
        this.itemInventory.clear();
    }

    public boolean done() {
        return this.lastSlot >= this.slots;
    }

    protected void clearAndInitData(ChestInvsData data) {
        this.clear();
        this.initData(data);
    }

    protected void initData(ChestInvsData data) {
        this.chestPoses.addAll(data.chestPoses());
        this.chestBes.addAll(data.chestBes());
        this.chestItemHandlers.addAll(data.chestItemHandlers());
        this.slots = data.invSlots();
        this.allItemHandlers = new WrapperItemHandler(this.chestItemHandlers);
    }

    public List<BlockPos> getChestPoses() {
        return this.chestPoses;
    }

    public List<BlockEntity> getChestBes() {
        return this.chestBes;
    }

    public List<IItemHandler> getChestItemHandlers() {
        return this.chestItemHandlers;
    }

    public ItemInventory getItemInventory() {
        return this.itemInventory;
    }

    public WrapperItemHandler getAllItemHandlers() {
        return this.allItemHandlers;
    }

    public int getSlots() {
        return this.slots;
    }
}

