/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.task.cook.common.task.TaskCook;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;

public class CookerForPicnicTask
extends MaidCheckRateTask {
    public static final int MAX_CHECK_RATE = 1200;

    public CookerForPicnicTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.setMaxCheckRate(1200);
    }

    private static boolean picnicMatHasFood(TileEntityPicnicMat picnicMat) {
        ItemStackHandler handler = picnicMat.getHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        return super.checkExtraStartConditions(worldIn, maid) && maid.getTask() instanceof TaskCook;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        TileEntityPicnicMat picnicMat;
        Entity entity = maid.m_20202_();
        if (!(entity instanceof EntitySit)) {
            return;
        }
        EntitySit sit = (EntitySit)entity;
        ItemStack hudItem = ItemCulinaryHub.getItem(maid);
        if (hudItem.m_41619_()) {
            return;
        }
        BlockPos onPos = maid.m_20202_().m_20183_();
        BlockEntity blockEntity = worldIn.m_7702_(onPos);
        if (!(blockEntity instanceof TileEntityPicnicMat) || CookerForPicnicTask.picnicMatHasFood(picnicMat = (TileEntityPicnicMat)blockEntity)) {
            return;
        }
        List<BlockPos> outputPoses = ItemCulinaryHub.getBindPoses(hudItem).get((Object)BagType.OUTPUT);
    }

    @Nullable
    private BlockPos findPicnicMat(ServerLevel world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PoiManager poiManager = world.m_8904_();
        int range = (int)maid.m_21535_();
        return poiManager.m_27181_(type -> ((PoiType)type.get()).equals(InitPoi.HOME_MEAL_BLOCK.get()), blockPos, range, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(pos -> !this.isOccupied(world, (BlockPos)pos)).min(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)maid.m_20183_()))).orElse(null);
    }

    private boolean isOccupied(ServerLevel worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)te;
            for (UUID uuid : picnicMat.getSitIds()) {
                if (uuid.equals(Util.f_137441_)) {
                    return false;
                }
                if (worldIn.m_8791_(uuid) != null) continue;
                return false;
            }
        }
        return true;
    }
}

