/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.compress.utils.Lists;

public final class ByteBufUtil {
    public static <C> void writeCustomList(List<C> list, FriendlyByteBuf buf, Consumer<C> cConsumer) {
        buf.m_130130_(list.size());
        for (C c : list) {
            cConsumer.accept(c);
        }
    }

    public static <C> List<C> readCustomList(FriendlyByteBuf buf, Function<FriendlyByteBuf, C> byteBufFunction) {
        int size = buf.m_130242_();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            list.add(byteBufFunction.apply(buf));
        }
        return list;
    }

    public static void writeStrList(List<String> list, FriendlyByteBuf buf) {
        ByteBufUtil.writeCustomList(list, buf, arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
    }

    public static List<String> readStrList(List<String> list, FriendlyByteBuf buf) {
        return ByteBufUtil.readCustomList(buf, FriendlyByteBuf::m_130277_);
    }

    public static void writeMapSB(Map<String, Boolean> map, FriendlyByteBuf buf) {
        buf.m_130130_(map.size());
        map.forEach((key, value) -> {
            buf.m_130070_(key);
            buf.writeBoolean(value.booleanValue());
        });
    }

    public static Map<String, Boolean> readMapSB(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            map.put(buf.m_130277_(), buf.readBoolean());
        }
        return map;
    }

    public static <C> void writeMapSCustom(Map<String, C> map, FriendlyByteBuf buf, Consumer<C> cConsumer) {
        buf.m_130130_(map.size());
        map.forEach((key, value) -> {
            buf.m_130070_(key);
            cConsumer.accept(value);
        });
    }

    public static <C> Map<String, C> readMapSCustom(FriendlyByteBuf buf, Function<FriendlyByteBuf, C> byteBufCFunction) {
        int size = buf.m_130242_();
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            map.put(buf.m_130277_(), byteBufCFunction.apply(buf));
        }
        return map;
    }
}

