/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.youkaishomecoming.ferment;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.AutoCraftGuideGeneratorRegister;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.ICookingRecipeGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.custom.SneakCommonUseAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftGuideOperator2;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.TargetUtil;
import com.github.wallev.maidsoulkitchen.compat.msm.youkaishomecoming.base.IYhcRecipe;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.item.fluid.IYHFluidHolder;
import dev.xkmc.youkaishomecoming.content.item.fluid.SakeBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationRecipe;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationTankBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.ferment.SimpleFermentationRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;

@AutoCraftGuideGeneratorRegister(value=TaskInfo.MSM_YHC_FERMENT)
public class GeneratorYhcFermentGuide
implements ICookingRecipeGuideGenerator<FermentationRecipe<?>>,
IYhcRecipe<SimpleFermentationRecipe> {
    private final Map<FermentationRecipe<?>, Ingredient> inFluidItems = new HashMap();
    private final Map<Fluid, List<ItemStack>> fluidContainers = new HashMap<Fluid, List<ItemStack>>();
    private final Map<Fluid, List<Pair<ItemStack, Integer>>> fluidItems = new HashMap<Fluid, List<Pair<ItemStack, Integer>>>();

    @Override
    public boolean isValidBlockInWorld(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return true;
    }

    @Override
    @NotNull
    public ResourceLocation getType() {
        return VResourceLocation.createTypeMod(YHBlocks.FERMENT_RT.getId());
    }

    @Override
    public <T extends Container> T convert2InputsInv(List<ItemStack> allInputs) {
        return null;
    }

    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_7702_(pos) instanceof FermentationTankBlockEntity;
    }

    @Override
    public RecipeType<FermentationRecipe<?>> getRecipeType() {
        return (RecipeType)YHBlocks.FERMENT_RT.get();
    }

    @Override
    public void generateSteps(BlockPos pos, Level level, FermentationRecipe<?> recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        CraftGuideOperator2.forEachSingleItem(realItems, craftGuide::addItemUse);
        craftGuide.addEmptyUse();
        int fermentationTime = recipe.getFermentationTime();
        craftGuide.addIdle(fermentationTime + 10);
        if (needContainer) {
            CraftGuideOperator2.forEachSingleItem(containers, itemStack -> craftGuide.addItemUse((ItemStack)itemStack, ((ItemStack)outputs.get(0)).m_255036_(1)));
        } else {
            craftGuide.addStep(new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(), List.of(), SneakCommonUseAction.TYPE, ActionOptionSet.with(SneakCommonUseAction.SNEAK, (Object)true)));
            craftGuide.addItemPickup(outputs);
        }
    }

    @Override
    public int getRecipeTime(FermentationRecipe<?> recipe) {
        return recipe.getFermentationTime();
    }

    @Override
    public void onCache(RecipeManager manager) {
        this.clear();
        this.buildFluidItems(manager);
    }

    private void clear() {
        this.fluidContainers.clear();
        this.fluidItems.clear();
    }

    public void buildFluidItems(RecipeManager manager) {
        HashMap fluidContainers = new HashMap();
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            ItemStack container;
            if (fluid instanceof EmptyFluid || (container = fluid.m_6859_().m_7968_().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers.containsKey(fluid)) {
                List itemStacks = fluidContainers.getOrDefault(fluid, Collections.emptyList());
                if (!itemStacks.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks.add(container);
                continue;
            }
            fluidContainers.put(fluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
        HashMap fluidItems = new HashMap();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack container;
            if (item instanceof SakeBottleItem) {
                ItemStack container2;
                SakeBottleItem sakeBottleItem = (SakeBottleItem)item;
                YHFluid fluid = sakeBottleItem.getFluid();
                IYHFluidHolder iyhSake = fluid.type;
                Fluid rawFluid = fluid.m_5613_();
                if (fluidItems.containsKey(rawFluid)) {
                    List oFluidItems = fluidItems.getOrDefault(rawFluid, Collections.emptyList());
                    if (oFluidItems.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(item))) {
                        ((List)fluidItems.get(rawFluid)).add(Pair.of((Object)item.m_7968_(), (Object)iyhSake.amount()));
                    }
                } else {
                    fluidItems.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)item.m_7968_(), (Object)iyhSake.amount())}));
                }
                if ((container2 = iyhSake.getContainer().m_7968_()).m_41619_()) continue;
                if (fluidContainers.containsKey(rawFluid)) {
                    List itemStacks = fluidContainers.getOrDefault(rawFluid, Collections.emptyList());
                    if (!itemStacks.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container2.m_41720_()))) continue;
                    itemStacks.add(container2);
                    continue;
                }
                fluidContainers.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container2}));
                continue;
            }
            ItemStack defaultInstance = item.m_7968_().m_41777_();
            IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)defaultInstance.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
            if (iFluidHandlerItem == null || !(iFluidHandlerItem instanceof FluidBucketWrapper)) continue;
            FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
            FluidStack fluidStack = fluidBucketWrapper.getFluid();
            Fluid rawFluid = fluidStack.getRawFluid();
            if (fluidStack.isEmpty() || rawFluid instanceof EmptyFluid) continue;
            if (fluidItems.containsKey(rawFluid)) {
                List oFluidItems = fluidItems.getOrDefault(rawFluid, Collections.emptyList());
                if (oFluidItems.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(defaultInstance.m_41720_()))) {
                    ((List)fluidItems.get(rawFluid)).add(Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount()));
                }
            } else {
                fluidItems.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount())}));
            }
            if ((container = fluidBucketWrapper.getContainer().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers.containsKey(rawFluid)) {
                List itemStacks = fluidContainers.getOrDefault(rawFluid, Collections.emptyList());
                if (!itemStacks.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks.add(container);
                continue;
            }
            fluidContainers.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
        this.fluidContainers.putAll(fluidContainers);
        this.fluidItems.putAll(fluidItems);
        this.consumeRecipes(manager, oRecipe -> {
            if (!this.shouldCacheRecipe(oRecipe)) {
                return;
            }
            if (!this.isValidRecipe(oRecipe)) {
                return;
            }
            SimpleFermentationRecipe recipe = (SimpleFermentationRecipe)this.castRecipe((Recipe)oRecipe);
            FluidStack fluidIn = recipe.inputFluid;
            if (fluidIn != null && !fluidIn.isEmpty()) {
                ArrayList inFluidItems = new ArrayList();
                if (fluidItems.keySet().stream().anyMatch(fluid -> fluid.m_6212_(fluidIn.getFluid()))) {
                    fluidItems.forEach((fluid, itemStacks) -> {
                        if (fluid.m_6212_(fluidIn.getFluid())) {
                            for (Pair fluidStackPair : itemStacks) {
                                ItemStack outputFluidItem = ((ItemStack)fluidStackPair.getFirst()).m_41777_();
                                int amount = (Integer)fluidStackPair.getSecond();
                                int amountTotal = fluidIn.getAmount();
                                outputFluidItem.m_41764_(Math.max(1, amountTotal / amount));
                                if (!inFluidItems.stream().noneMatch(itemStack -> itemStack.m_150930_(outputFluidItem.m_41720_()) && itemStack.m_41613_() == outputFluidItem.m_41613_())) continue;
                                inFluidItems.add(outputFluidItem);
                            }
                        }
                    });
                }
                Ingredient fluidIngredient = Ingredient.m_43921_(inFluidItems.stream());
                List<Ingredient> allInputs = this.getAllInputs(recipe);
                ResourceLocation recipeId = recipe.m_6423_();
                RecipeIngredientCache.addRecipeCache((ResourceLocation)recipeId, allInputs);
                this.inFluidItems.put((FermentationRecipe<?>)recipe, fluidIngredient);
            } else {
                List<Ingredient> allInputs = this.getAllInputs(recipe);
                ResourceLocation recipeId = recipe.m_6423_();
                RecipeIngredientCache.addRecipeCache((ResourceLocation)recipeId, allInputs);
                this.inFluidItems.put((FermentationRecipe<?>)recipe, Ingredient.f_43901_);
            }
        });
    }

    @Override
    public List<Ingredient> getInputs(FermentationRecipe<?> recipe) {
        ArrayList allInputs = Lists.newArrayList();
        Ingredient fluidIngredient = this.inFluidItems.getOrDefault(recipe, Ingredient.f_43901_);
        if (!fluidIngredient.m_43947_()) {
            allInputs.add(fluidIngredient);
        }
        ArrayList allInputsNoFluid = ((SimpleFermentationRecipe)this.castRecipe(recipe)).ingredients;
        allInputs.addAll(allInputsNoFluid);
        return allInputs;
    }

    @Override
    public List<Ingredient> getContainers(FermentationRecipe<?> recipe) {
        SimpleFermentationRecipe simpleFermentationRecipe = (SimpleFermentationRecipe)this.castRecipe((Recipe)recipe);
        FluidStack outputFluid = simpleFermentationRecipe.outputFluid;
        Fluid fluid = outputFluid.getFluid();
        List<Object> containers = this.fluidContainers.getOrDefault(fluid, List.of());
        if (fluid instanceof YHFluid) {
            YHFluid sakeFluid = (YHFluid)fluid;
            containers = this.fluidContainers.getOrDefault(fluid, List.of()).stream().map(itemStack -> itemStack.m_255036_(sakeFluid.type.count())).toList();
        }
        if (containers.isEmpty()) {
            return List.of();
        }
        return List.of(Ingredient.m_43921_(containers.stream()));
    }

    @Override
    public List<ItemStack> getOutputs(FermentationRecipe<?> recipe, RegistryAccess registryAccess) {
        ItemStack output;
        SimpleFermentationRecipe sFermentationRecipe = (SimpleFermentationRecipe)recipe;
        FluidStack outputFluid = sFermentationRecipe.outputFluid;
        Fluid fluid = outputFluid.getFluid();
        if (fluid instanceof YHFluid) {
            YHFluid sakeFluid = (YHFluid)fluid;
            output = sakeFluid.type.asStack(sakeFluid.type.count());
        } else if (!sFermentationRecipe.defaultContainer.m_41619_() && !sFermentationRecipe.defaultBottle.m_41619_()) {
            output = sFermentationRecipe.defaultBottle;
        } else {
            ArrayList oResults = Lists.newArrayList();
            for (ItemStack result : sFermentationRecipe.results) {
                boolean grow = false;
                for (ItemStack oResult : oResults) {
                    if (!ItemStack.m_150942_((ItemStack)result, (ItemStack)oResult)) continue;
                    oResult.m_41769_(result.m_41613_());
                    grow = true;
                    break;
                }
                if (grow) continue;
                oResults.add(result.m_41777_());
            }
            return oResults;
        }
        return List.of(output);
    }

    @Override
    public Item getBlockItemForTranslate() {
        return YHBlocks.FERMENT.m_5456_();
    }

    @Override
    public boolean matchResultCount() {
        return true;
    }
}

