/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.mixin;

import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.RecipeFillButtonWidget;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.widget.RecipeButtonWidget;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import studio.fantasyit.maid_storage_manager.integration.Integrations;
import studio.fantasyit.maid_storage_manager.integration.request.EMIClient;
import studio.fantasyit.maid_storage_manager.integration.request.IngredientRequestClient;

@Mixin(value={RecipeFillButtonWidget.class})
public abstract class EMIRecipeTransferHook
extends RecipeButtonWidget {
    public EMIRecipeTransferHook(int x, int y, int u, int v, EmiRecipe recipe) {
        super(x, y, u, v, recipe);
    }

    @ModifyVariable(method={"getTooltip"}, at=@At(value="RETURN"), remap=false)
    public List<ClientTooltipComponent> tooltip(List<ClientTooltipComponent> tooltip) {
        if (!Integrations.EMIngredientRequest()) {
            return tooltip;
        }
        if (IngredientRequestClient.keyPressed) {
            tooltip.clear();
            if (IngredientRequestClient.preferMaidId != -1) {
                tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"tooltip.maid_storage_manager.jei_request.from_maid", (Object[])new Object[]{IngredientRequestClient.preferMaidName}).m_7532_()));
            } else {
                tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237115_((String)"tooltip.maid_storage_manager.jei_request.no_maid").m_7532_()));
            }
        }
        return tooltip;
    }

    public void m_88315_(GuiGraphics raw, int mouseX, int mouseY, float delta) {
        if (Integrations.EMIngredientRequest()) {
            IngredientRequestClient.hasButton();
            if (IngredientRequestClient.keyPressed) {
                int offset = super.getTextureOffset(mouseX, mouseY);
                if (IngredientRequestClient.preferMaidId == -1) {
                    offset = 24;
                }
                EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)raw);
                context.resetColor();
                context.drawTexture(EmiRenderHelper.BUTTONS, this.x, this.y, 12, 12, 72.0f, (float)offset, 12, 12, 256, 256);
                IngredientRequestClient.drawIcon(raw, this.x + 1, this.y + 1);
                return;
            }
        }
        super.m_88315_(raw, mouseX, mouseY, delta);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void mouseClicked(int mouseX, int mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (!Integrations.EMIngredientRequest()) {
            return;
        }
        if (IngredientRequestClient.keyPressed && IngredientRequestClient.preferMaidId != -1) {
            EMIClient.processRequestNearByClient(this.recipe);
            cir.setReturnValue((Object)true);
        }
    }
}

