/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.InventoryListUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class JEICommonRecipeHandler
implements IUniversalRecipeTransferHandler<CommonCraftMenu> {
    @NotNull
    public Class getContainerClass() {
        return CommonCraftMenu.class;
    }

    @NotNull
    public Optional<MenuType<CommonCraftMenu>> getMenuType() {
        return Optional.of((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_COMMON.get());
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull CommonCraftMenu container, @NotNull Object recipe, IRecipeSlotsView recipeSlots, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        ArrayList outputs = new ArrayList();
        recipeSlots.getSlotViews(RecipeIngredientRole.OUTPUT).stream().map(e -> e.getItemStacks().findFirst().orElse(ItemStack.f_41583_)).filter(i -> !i.m_41619_()).forEach(i -> ItemStackUtil.addToList((List<ItemStack>)outputs, i.m_41777_(), true));
        ArrayList inputs = new ArrayList();
        recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().map(e -> InventoryListUtil.getMatchingForPlayer(e.getItemStacks().toList())).filter(i -> !i.m_41619_()).forEach(i -> ItemStackUtil.addToList((List<ItemStack>)inputs, i.m_41777_(), true));
        int inputId = 0;
        int outputId = 0;
        CompoundTag data = new CompoundTag();
        ListTag inputTag = new ListTag();
        ListTag outputTag = new ListTag();
        for (CraftGuideStepData step : container.craftGuideData.steps) {
            int i2;
            for (i2 = 0; i2 < step.actionType.inputCount(); ++i2) {
                if (inputId >= inputs.size()) continue;
                if (doTransfer) {
                    inputTag.add((Object)ItemStackUtil.saveStack((ItemStack)inputs.get(inputId)));
                }
                ++inputId;
            }
            for (i2 = 0; i2 < step.actionType.outputCount(); ++i2) {
                if (outputId >= outputs.size()) continue;
                if (doTransfer) {
                    outputTag.add((Object)ItemStackUtil.saveStack((ItemStack)outputs.get(outputId)));
                }
                ++outputId;
            }
        }
        if (doTransfer) {
            data.m_128365_("inputs", (Tag)inputTag);
            data.m_128365_("outputs", (Tag)outputTag);
            Network.INSTANCE.sendToServer((Object)new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_ALL_INPUT, 0, 0, data));
        }
        if (inputId != inputs.size() || outputId != outputs.size()) {
            return new ExceedError();
        }
        return null;
    }

    public static class ExceedError
    implements IRecipeTransferError {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void getTooltip(ITooltipBuilder tooltip) {
            tooltip.add((FormattedText)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.jei.too_many_to_transfer"));
        }
    }
}

