/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.menu.FilterMenu;
import studio.fantasyit.maid_storage_manager.menu.base.AbstractFilterScreen;
import studio.fantasyit.maid_storage_manager.menu.base.IItemTarget;
import studio.fantasyit.maid_storage_manager.menu.container.ButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.InventorySelectButton;
import studio.fantasyit.maid_storage_manager.network.ItemSelectorGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.util.InventoryListUtil;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
@IPNIgnore
public class FilterScreen
extends AbstractFilterScreen<FilterMenu>
implements IItemTarget {
    private static final ResourceLocation background = new ResourceLocation("maid_storage_manager", "textures/gui/filter_list.png");
    private InventorySelectButton inventorySelectButton;

    public FilterScreen(FilterMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_);
        this.f_97726_ = 176;
        this.f_97727_ = 200;
        this.f_97731_ = this.f_97727_ - 94;
        this.addButtons();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButtons();
        this.addInventoryListButton();
        this.refreshUUID(true);
    }

    private void addButtons() {
        this.m_142416_((GuiEventListener)new ButtonWidget(137, 83, 16, 16, background, widget -> {
            if (((FilterMenu)this.m_6262_()).matchTag) {
                return new Pair((Object)208, (Object)(widget.m_274382_() ? 16 : 0));
            }
            return new Pair((Object)224, (Object)(widget.m_274382_() ? 16 : 0));
        }, () -> ((FilterMenu)this.m_6262_()).matchTag ? Component.m_237115_((String)"gui.maid_storage_manager.filter_list.match_tag_on") : Component.m_237115_((String)"gui.maid_storage_manager.filter_list.match_tag_off"), () -> {
            ((FilterMenu)this.m_6262_()).matchTag = !((FilterMenu)this.m_6262_()).matchTag;
            Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.MATCH_TAG, 0, ((FilterMenu)this.m_6262_()).matchTag ? 1 : 0);
        }, this));
        this.m_142416_((GuiEventListener)new ButtonWidget(137, 65, 16, 16, background, widget -> {
            if (((FilterMenu)this.m_6262_()).isBlackList) {
                return new Pair((Object)192, (Object)(widget.m_274382_() ? 16 : 0));
            }
            return new Pair((Object)176, (Object)(widget.m_274382_() ? 16 : 0));
        }, () -> ((FilterMenu)this.m_6262_()).isBlackList ? Component.m_237115_((String)"gui.maid_storage_manager.filter_list.blacklist") : Component.m_237115_((String)"gui.maid_storage_manager.filter_list.whitelist"), () -> {
            ((FilterMenu)this.m_6262_()).isBlackList = !((FilterMenu)this.m_6262_()).isBlackList;
            Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.BLACKLIST, 0, ((FilterMenu)this.m_6262_()).isBlackList ? 1 : 0);
        }, this));
    }

    protected void addInventoryListButton() {
        this.inventorySelectButton = (InventorySelectButton)this.m_142416_((GuiEventListener)new InventorySelectButton(this.getGuiLeft() + 12, this.getGuiTop() + 85, (Screen)this));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        this.m_280273_(guiGraphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280398_(background, relX, relY, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    public void m_88315_(GuiGraphics graphics, int p_283661_, int p_281248_, float p_281886_) {
        super.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        this.m_280072_(graphics, p_283661_, p_281248_);
    }

    protected void m_280072_(GuiGraphics graphics, int x, int y) {
        if (((FilterMenu)this.f_97732_).m_142621_().m_41619_()) {
            int inGuiX = x - this.getGuiLeft();
            int inGuiY = y - this.getGuiTop();
            for (Slot slot : ((FilterMenu)this.m_6262_()).f_38839_) {
                if (slot.f_40220_ > inGuiX || slot.f_40220_ + 16 < inGuiX || slot.f_40221_ > inGuiY || slot.f_40221_ + 16 < inGuiY || !(slot instanceof FilterSlot)) continue;
                FilterSlot filterSlot = (FilterSlot)slot;
                if (!filterSlot.m_7993_().m_41619_()) {
                    graphics.m_280153_(this.f_96547_, filterSlot.m_7993_(), x, y);
                }
                return;
            }
            this.m_6702_().forEach(renderable -> {
                if (renderable.m_5953_((double)x, (double)y)) {
                    if (renderable instanceof ButtonWidget) {
                        ButtonWidget buttonWidget = (ButtonWidget)((Object)renderable);
                        graphics.m_280557_(this.f_96547_, buttonWidget.getTooltipComponent(), x, y);
                    } else if (renderable instanceof InventorySelectButton) {
                        InventorySelectButton buttonWidget = (InventorySelectButton)((Object)renderable);
                        graphics.m_280557_(this.f_96547_, buttonWidget.getTooltipComponent(), x, y);
                    }
                }
            });
        }
        super.m_280072_(graphics, x, y);
    }

    @Override
    public void accept(FilterSlot menu, ItemStack item) {
        ItemStack itemStack = item.m_255036_(1);
        ((FilterMenu)this.m_6262_()).filteredItems.m_6836_(menu.m_150661_(), itemStack);
        Network.sendItemSelectorSetItemPacket(menu.m_150661_(), itemStack);
    }

    protected void m_181908_() {
        this.refreshUUID(false);
    }

    protected void refreshUUID(boolean force) {
        UUID inventoryListUUIDFromPlayerInv;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (player.f_19797_ % 20 == 0 || force) && (inventoryListUUIDFromPlayerInv = InventoryListUtil.getInventoryListUUIDFromPlayerInv((List<ItemStack>)player.f_36093_.f_35974_)) != null) {
            this.inventorySelectButton.setUUID(inventoryListUUIDFromPlayerInv);
        }
    }

    @Override
    public List<FilterSlot> getSlots() {
        return ((FilterMenu)this.m_6262_()).f_38839_.stream().filter(slot -> slot instanceof FilterSlot).map(slot -> (FilterSlot)((Object)slot)).toList();
    }

    @Override
    public void itemSelected(ItemStack stack) {
        for (FilterSlot slot : this.getSlots()) {
            if (!slot.m_6659_() || !slot.m_7993_().m_41619_()) continue;
            this.accept(slot, stack);
            break;
        }
    }
}

