/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.menu.container.FilterContainer;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;
import studio.fantasyit.maid_storage_manager.network.ItemSelectorGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;

public class FilterMenu
extends AbstractContainerMenu
implements ISaveFilter {
    public boolean isBlackList;
    Player player;
    ItemStack target;
    ItemFrame targetIfr = null;
    public FilterContainer filteredItems;
    public boolean matchTag = false;

    public FilterMenu(int p_38852_, Player player, int entityId) {
        super((MenuType)GuiRegistry.FILTER_MENU.get(), p_38852_);
        this.player = player;
        if (entityId == -1) {
            this.target = player.m_21205_();
        } else {
            Entity entity = player.m_9236_().m_6815_(entityId);
            if (entity instanceof ItemFrame) {
                ItemFrame ifr;
                this.targetIfr = ifr = (ItemFrame)entity;
                this.target = ifr.m_31822_();
            }
        }
        CompoundTag tag = this.target.m_41784_();
        this.filteredItems = new FilterContainer(27, this);
        this.filteredItems.deserializeNBT(tag.m_128437_("items", 10));
        this.matchTag = tag.m_128471_("match_tag");
        this.isBlackList = tag.m_128471_("black_mode");
        this.addPlayerSlots();
        this.addFilterSlots();
        this.addSpecialSlots();
    }

    @Override
    public void save() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = this.target.m_41784_();
        ListTag list = new ListTag();
        if (tag.m_128441_("items")) {
            list = tag.m_128437_("items", 10);
        }
        while (list.size() <= this.filteredItems.m_6643_()) {
            list.add((Object)new CompoundTag());
        }
        for (int i = 0; i < this.filteredItems.m_6643_(); ++i) {
            CompoundTag tmp = new CompoundTag();
            tmp.m_128365_("item", (Tag)this.filteredItems.m_8020_(i).serializeNBT());
            list.set(i, (Tag)tmp);
        }
        tag.m_128365_("items", (Tag)list);
        tag.m_128379_("black_mode", this.isBlackList);
        tag.m_128379_("match_tag", this.matchTag);
        this.target.m_41751_(tag);
    }

    private void addFilterSlots() {
        int cellHeight = 18;
        int cellWidth = 18;
        int startY = 17;
        int startX = 45;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m_38897_(new FilterSlot(this.filteredItems, i * 4 + j, 45 + j * 18, 17 + i * 18));
            }
        }
    }

    private void addPlayerSlots() {
        int i;
        int cellHeight = 18;
        int cellWidth = 18;
        int startY = 118;
        int startX = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), 9 + i * 9 + j, 8 + j * 18, 118 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), i, 8 + i * 18, 176));
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && (slot = this.m_38853_(slotId)) instanceof FilterSlot) {
            ItemStack insert;
            FilterSlot fs = (FilterSlot)slot;
            int slot2 = fs.m_150661_();
            if (clickTypeIn == ClickType.THROW) {
                return;
            }
            ItemStack held = this.m_142621_();
            if (clickTypeIn == ClickType.CLONE) {
                if (player.m_7500_() && held.m_41619_()) {
                    ItemStack stackInSlot = this.filteredItems.m_8020_(slot2).m_41777_();
                    stackInSlot.m_41764_(stackInSlot.m_41741_());
                    this.m_142503_(stackInSlot);
                    return;
                }
                return;
            }
            if (held.m_41619_()) {
                insert = ItemStack.f_41583_;
            } else {
                insert = held.m_41777_();
                insert.m_41764_(1);
            }
            this.filteredItems.m_6836_(slot2, insert);
            this.m_38853_(slotId).m_6654_();
        } else {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    private void addSpecialSlots() {
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return FilterMenu.this.matchTag ? 1 : 0;
            }

            public void m_6422_(int p_40208_) {
                FilterMenu.this.matchTag = p_40208_ == 1;
                FilterMenu.this.save();
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return FilterMenu.this.isBlackList ? 1 : 0;
            }

            public void m_6422_(int p_40208_) {
                FilterMenu.this.isBlackList = p_40208_ == 1;
                FilterMenu.this.save();
            }
        });
    }

    @NotNull
    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        Slot slot = this.m_38853_(p_38942_);
        if (slot.m_6657_()) {
            if (slot instanceof FilterSlot) {
                FilterSlot fs = (FilterSlot)slot;
                fs.m_5852_(ItemStack.f_41583_);
            } else {
                int i;
                int containerSize = this.filteredItems.m_6643_();
                boolean found = false;
                for (i = 0; i < containerSize; ++i) {
                    if (!ItemStack.m_150942_((ItemStack)this.filteredItems.m_8020_(i), (ItemStack)slot.m_7993_())) continue;
                    found = true;
                }
                if (!found) {
                    for (i = 0; i < containerSize; ++i) {
                        if (!this.filteredItems.m_8020_(i).m_41619_()) continue;
                        this.filteredItems.m_6836_(i, slot.m_7993_().m_255036_(1));
                        break;
                    }
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        if (this.targetIfr != null && this.targetIfr.m_6084_()) {
            return (double)this.targetIfr.m_20270_((Entity)player) <= player.getEntityReach();
        }
        return player.m_21205_() == this.target;
    }

    public void handleUpdate(ItemSelectorGuiPacket.SlotType type, int key, int value) {
        switch (type) {
            case MATCH_TAG: {
                this.matchTag = value == 1;
                this.save();
                break;
            }
            case BLACKLIST: {
                this.isBlackList = value == 1;
                this.save();
            }
        }
    }

    public boolean m_5622_(Slot p_38945_) {
        return !(p_38945_ instanceof FilterSlot);
    }
}

