/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.resort;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;

public class ResortMoveBehavior
extends Behavior<EntityMaid> {
    public ResortMoveBehavior() {
        super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        return MemoryUtil.getCurrentlyWorking(owner) == ScheduleBehavior.Schedule.RESORT;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        Target storage;
        @Nullable Target target = MemoryUtil.getResorting(maid).getTarget();
        Target target2 = storage = target == null ? null : MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, target.pos, target.side);
        if (target == null || storage == null) {
            DebugData.sendDebug("[RESORT]No Target", new Object[0]);
            MemoryUtil.getResorting(maid).clearNeedToResort();
            MemoryUtil.getResorting(maid).clearTarget();
            return;
        }
        if (!storage.getType().equals((Object)MemoryUtil.getResorting(maid).getTarget().getType())) {
            DebugData.sendDebug("[RESORT]Target Changed", new Object[0]);
            MemoryUtil.getResorting(maid).clearNeedToResort();
            MemoryUtil.getResorting(maid).clearTarget();
            return;
        }
        BlockPos goal = MoveUtil.selectPosForTarget(level, maid, target.getPos());
        if (goal == null) {
            return;
        }
        DebugData.sendDebug("[RESORT]Target %s", goal.m_123344_());
        MemoryUtil.setTarget(maid, goal, (float)Config.collectSpeed);
    }
}

