/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.base;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.behavior.base.MaidMoveToBlockTaskWithArrivalMap;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StoragePredictor;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.PosUtil;

public abstract class AbstractGatherMoveBehavior
extends MaidMoveToBlockTaskWithArrivalMap {
    private final float moveSpeed;
    boolean hasAnyFailPathing;
    Target chestPos = null;

    public AbstractGatherMoveBehavior(float speed) {
        super(speed, 3);
        this.verticalSearchStart = 1;
        this.moveSpeed = speed;
    }

    protected abstract AbstractTargetMemory getMemory(EntityMaid var1);

    protected abstract boolean hasFinishedPre(ServerLevel var1, EntityMaid var2);

    protected abstract void findTarget(ServerLevel var1, EntityMaid var2, Target var3);

    protected abstract void noTarget(ServerLevel var1, EntityMaid var2);

    @NotNull
    protected abstract List<ItemStack> getPriorityItems(ServerLevel var1, EntityMaid var2);

    protected boolean isTargetItem(ServerLevel level, EntityMaid maid, List<ItemStack> targets, ItemStack itemStack) {
        return targets.stream().anyMatch(i2 -> ItemStack.m_41656_((ItemStack)i2, (ItemStack)itemStack));
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        super.m_6735_(level, (LivingEntity)maid, p_22542_);
        this.hasAnyFailPathing = false;
        AbstractTargetMemory memory = this.getMemory(maid);
        if (this.hasFinishedPre(level, maid)) {
            return;
        }
        if (!this.priorityTarget(level, maid) && Conditions.useScanTarget(maid)) {
            this.searchForDestination(level, maid);
        }
        if (!maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get())) {
            if (memory.confirmNoTarget()) {
                if (this.hasAnyFailPathing && maid.m_21536_() && maid.m_20238_(maid.m_21534_().m_252807_()) > 9.0) {
                    MemoryUtil.goRestrictCenterAndWait(maid, (float)Config.collectSpeed);
                    return;
                }
                DebugData.sendDebug("[GATHERING] No More Target", new Object[0]);
                this.noTarget(level, maid);
            }
        } else {
            memory.resetFailCount();
            if (this.chestPos != null) {
                memory.setTarget(this.chestPos);
                MemoryUtil.setLookAt(maid, this.chestPos.getPos());
                DebugData.sendDebug("[GATHERING] Target %s", this.chestPos);
            }
            this.findTarget(level, maid, this.chestPos);
        }
    }

    private boolean priorityTarget(ServerLevel level, EntityMaid maid) {
        if (!Conditions.usePriorityTarget(maid)) {
            return false;
        }
        AbstractTargetMemory memory = this.getMemory(maid);
        List<ItemStack> targets = this.getPriorityItems(level, maid);
        if (targets.isEmpty()) {
            return false;
        }
        Map<Target, List<ViewedInventoryMemory.ItemCount>> viewed = MemoryUtil.getViewedInventory(maid).positionFlatten();
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
        for (Map.Entry<Target, List<ViewedInventoryMemory.ItemCount>> blockPos : viewed.entrySet()) {
            List<BlockPos> possiblePos;
            Target storage;
            Optional<ViewedInventoryMemory.ItemCount> first;
            if (memory.isVisitedPos(blockPos.getKey()) || (first = blockPos.getValue().stream().filter(itemCount -> this.isTargetItem(level, maid, targets, itemCount.item())).findFirst()).isEmpty() || (storage = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, blockPos.getKey().getPos(), blockPos.getKey().side)) == null || !MoveUtil.isValidTarget(level, maid, storage, false) || (possiblePos = MoveUtil.getAllAvailablePosForTarget(level, maid, blockPos.getKey().getPos(), pathFinding)).isEmpty()) continue;
            @Nullable BlockPos targetPos = MoveUtil.getNearestFromTargetList(level, maid, possiblePos);
            if (targetPos == null) {
                pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
                this.hasAnyFailPathing = true;
                continue;
            }
            this.chestPos = storage;
            MemoryUtil.setTarget(maid, targetPos, this.moveSpeed);
            DebugData.sendDebug("[GATHERING]Priority By Content %s", storage);
            return true;
        }
        return false;
    }

    protected boolean shouldMoveTo(@NotNull ServerLevel serverLevel, EntityMaid entityMaid, @NotNull BlockPos blockPos) {
        if (!PosUtil.isSafePos((Level)serverLevel, blockPos)) {
            return false;
        }
        @Nullable Target canTouchChest = MoveUtil.findTargetForPos(serverLevel, entityMaid, blockPos, this.getMemory(entityMaid), false, StoragePredictor::isCollectable);
        if (canTouchChest != null) {
            this.chestPos = canTouchChest;
            DebugData.sendDebug("[GATHERING]Target %s", canTouchChest);
        }
        return canTouchChest != null;
    }
}

