/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.work;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.capability.CraftBlockOccupyDataProvider;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CraftLayer {
    public static Codec<CraftLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CraftGuideData.CODEC.optionalFieldOf("craft").forGetter(CraftLayer::getCraftData), (App)CraftGuideData.CODEC.listOf().fieldOf("usableCraft").forGetter(CraftLayer::getUsableCraftData), (App)ItemStack.f_41582_.listOf().fieldOf("item").forGetter(CraftLayer::getItems), (App)Codec.INT.listOf().fieldOf("collectedCounts").forGetter(CraftLayer::getCollectedCounts), (App)Codec.INT.fieldOf("count").forGetter(CraftLayer::getCount), (App)Codec.INT.fieldOf("doneCount").forGetter(CraftLayer::getDoneCount), (App)Codec.INT.fieldOf("tryTick").forGetter(CraftLayer::getTryTick), (App)Codec.INT.listOf().fieldOf("currentStepPlacedCounts").forGetter(CraftLayer::getCurrentStepCounts), (App)Codec.INT.fieldOf("step").forGetter(CraftLayer::getStep), (App)CompoundTag.f_128325_.orElseGet(CompoundTag::new).fieldOf("env").forGetter(CraftLayer::getEnv), (App)Codec.BOOL.fieldOf("placeBefore").forGetter(CraftLayer::shouldPlaceBefore)).apply((Applicative)instance, CraftLayer::new));
    protected int tryTick;
    protected CompoundTag env;
    protected CraftGuideData craftData;
    protected List<CraftGuideStepData> steps;
    protected List<CraftGuideData> usableCraftData;
    protected List<ItemStack> items;
    protected List<Integer> collectedCounts;
    protected List<Integer> currentStepCounts;
    protected int count;
    protected int doneCount;
    protected int step;
    private boolean placeBefore;

    public CraftLayer(Optional<CraftGuideData> craftData, List<CraftGuideData> usableCraftData, List<ItemStack> items, List<Integer> collectedCounts, Integer count, Integer doneCount, Integer tryTick, List<Integer> currentStepCounts, int step, CompoundTag env, boolean placeBefore) {
        this.usableCraftData = usableCraftData;
        this.craftData = craftData.orElse(null);
        this.steps = new ArrayList<CraftGuideStepData>(craftData.map(CraftGuideData::getTransformedSteps).orElse(new ArrayList()));
        this.items = new ArrayList<ItemStack>(items);
        this.collectedCounts = new ArrayList<Integer>(collectedCounts);
        this.count = count;
        this.doneCount = doneCount;
        this.currentStepCounts = new ArrayList<Integer>(currentStepCounts);
        this.step = step;
        this.tryTick = tryTick;
        this.env = env;
        this.placeBefore = placeBefore;
    }

    public CraftLayer(Optional<CraftGuideData> craftData, List<ItemStack> items, Integer count) {
        this.craftData = craftData.orElse(null);
        this.steps = new ArrayList<CraftGuideStepData>(craftData.map(CraftGuideData::getTransformedSteps).orElse(new ArrayList()));
        this.usableCraftData = List.of();
        this.items = new ArrayList<ItemStack>(items);
        this.tryTick = 0;
        this.collectedCounts = new ArrayList<Integer>();
        for (int i = 0; i < items.size(); ++i) {
            this.collectedCounts.add(0);
        }
        this.count = count;
        this.doneCount = 0;
        this.step = 0;
        this.currentStepCounts = new ArrayList<Integer>();
        this.env = new CompoundTag();
    }

    public CraftLayer(Optional<CraftGuideData> craftData, List<CraftGuideData> usableCraftData, List<ItemStack> items, int count) {
        this(craftData, items, count);
        this.setUsableCraftData(usableCraftData);
    }

    public List<CraftGuideData> getUsableCraftData() {
        return this.usableCraftData;
    }

    public void setUsableCraftData(List<CraftGuideData> usableCraftData) {
        this.usableCraftData = usableCraftData;
    }

    public boolean switchToNonOccupied(ServerLevel level, EntityMaid maid, int layerIndex, CraftBlockOccupyDataProvider.CraftBlockOccupy craftBlockOccupy) {
        if (this.step != 0) {
            return false;
        }
        for (CraftGuideData usable : this.getUsableCraftData()) {
            List<CraftGuideStepData> newSteps = usable.getTransformedSteps();
            if (!newSteps.stream().noneMatch(stepData -> craftBlockOccupy.isOccupiedByNonCurrent(maid, stepData.getStorage().pos, layerIndex))) continue;
            this.craftData = usable;
            this.steps = new ArrayList<CraftGuideStepData>(newSteps);
            return true;
        }
        return false;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getDoneCount() {
        return this.doneCount;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
    }

    public List<Integer> getCollectedCounts() {
        return this.collectedCounts;
    }

    public Optional<CraftGuideData> getCraftData() {
        return Optional.ofNullable(this.craftData);
    }

    public void addStep(CraftGuideStepData stepData) {
        this.steps.add(stepData);
    }

    public void clearNonFirstStep() {
        while (this.steps.size() > 1) {
            this.steps.remove(1);
        }
        this.step = 0;
    }

    public ItemStack memorizeItem(ItemStack itemStack, int maxStore) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!ItemStackUtil.isSameInCrafting(this.items.get(i), itemStack)) continue;
            int restNeed = this.items.get(i).m_41613_() - this.collectedCounts.get(i);
            int toTake = Math.min(Math.min(restNeed, maxStore), itemStack.m_41613_());
            this.collectedCounts.set(i, this.collectedCounts.get(i) + toTake);
            return itemStack.m_255036_(toTake);
        }
        return ItemStack.f_41583_;
    }

    public int memorizeItemSimulate(ItemStack itemStack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!ItemStackUtil.isSameInCrafting(this.items.get(i), itemStack)) continue;
            int restNeed = this.items.get(i).m_41613_() - this.collectedCounts.get(i);
            return Math.min(restNeed, itemStack.m_41613_());
        }
        return 0;
    }

    public void nextStep() {
        this.currentStepCounts = new ArrayList<Integer>();
        this.tryTick = 0;
        this.env = new CompoundTag();
        if (this.doneCount >= this.count) {
            return;
        }
        ++this.step;
        if (this.step == this.steps.size()) {
            ++this.doneCount;
            this.step = 0;
        }
    }

    public int getStep() {
        return this.step;
    }

    public boolean isDone() {
        return this.doneCount >= this.count;
    }

    public CraftGuideStepData getStepData() {
        if (this.craftData == null) {
            return null;
        }
        if (this.step >= this.steps.size()) {
            return null;
        }
        return this.steps.get(this.step);
    }

    public AbstractCraftActionContext startStep(EntityMaid maid) {
        if (this.craftData == null) {
            return null;
        }
        return CraftManager.getInstance().startCurrentStep(this, maid);
    }

    public boolean hasCollectedAll() {
        for (int i = 0; i < this.collectedCounts.size(); ++i) {
            if (this.collectedCounts.get(i) >= this.items.get(i).m_41613_()) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getUnCollectedItems() {
        ArrayList<ItemStack> unCollectedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.collectedCounts.size(); ++i) {
            if (this.collectedCounts.get(i) >= this.items.get(i).m_41613_()) continue;
            unCollectedItems.add(this.items.get(i).m_255036_(this.items.get(i).m_41613_() - this.collectedCounts.get(i)));
        }
        return unCollectedItems;
    }

    public void resetStep() {
        this.step = 0;
        this.tryTick = 0;
    }

    public List<Integer> getCurrentStepCounts() {
        return this.currentStepCounts;
    }

    public int getCurrentStepCount(int id) {
        if (this.currentStepCounts.size() <= id) {
            return 0;
        }
        return this.currentStepCounts.get(id);
    }

    public void addCurrentStepPlacedCounts(int id, int count) {
        while (this.currentStepCounts.size() <= id) {
            this.currentStepCounts.add(0);
        }
        this.currentStepCounts.set(id, this.currentStepCounts.get(id) + count);
    }

    public int getTotalStep() {
        return this.steps.size();
    }

    public void setCount(int i) {
        this.count = i;
    }

    public int addAndGetTryTick() {
        return ++this.tryTick;
    }

    public int getTryTick() {
        return this.tryTick;
    }

    public void setTryTick(int i) {
        this.tryTick = i;
    }

    public CompoundTag getEnv() {
        return this.env;
    }

    public void setEnv(CompoundTag env) {
        this.env = env;
    }

    public boolean equals(Object obj) {
        CraftLayer craftLayer;
        return obj instanceof CraftLayer && (craftLayer = (CraftLayer)obj).getCount().equals(this.count) && Objects.equals(craftLayer.getCraftData().orElse(null), this.craftData);
    }

    public CraftLayer copyWithNoState() {
        return new CraftLayer(Optional.ofNullable(this.craftData), this.usableCraftData, this.items, this.count);
    }

    public void setPlaceBefore() {
        this.placeBefore = true;
    }

    public void clearPlaceBefore() {
        this.placeBefore = false;
    }

    public boolean shouldPlaceBefore() {
        return this.placeBefore;
    }

    public int getExtraSlotConsume() {
        if (this.craftData != null) {
            return this.craftData.getExtraSlotConsume();
        }
        return 0;
    }
}

