/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public class CommonIdleAction
extends AbstractCraftActionContext {
    public static final ActionOption<Boolean> OPTION_WAIT = new ActionOption<Boolean>(new ResourceLocation("maid_storage_manager", "wait"), new Component[]{Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.idle_second"), Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.idle_tick")}, new ResourceLocation[]{new ResourceLocation("maid_storage_manager:textures/gui/craft/option/wait_second.png"), new ResourceLocation("maid_storage_manager:textures/gui/craft/option/wait_tick.png")}, "", new ActionOption.BiConverter<Integer, Boolean>(i -> i != 0, b -> b != false ? 1 : 0), ActionOption.ValuePredicatorOrGetter.predicator(t -> t.isBlank() || StringUtils.isNumeric((CharSequence)t) && Integer.parseInt(t) <= 999));
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "idle");
    int endTick = 0;

    public CommonIdleAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public void loadEnv(CompoundTag env) {
        this.endTick = env.m_128441_("endTick") ? env.m_128451_("endTick") : 0;
    }

    @Override
    public CompoundTag saveEnv(CompoundTag env) {
        env.m_128405_("endTick", this.endTick);
        return super.saveEnv(env);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        boolean u = this.craftGuideStepData.getOptionSelection(OPTION_WAIT).orElse(false);
        String timeStr = this.craftGuideStepData.getOptionValue(OPTION_WAIT);
        if (timeStr.isBlank()) {
            timeStr = "0";
        }
        int time = Integer.parseInt(timeStr);
        int v = time * (u ? 1 : 20);
        if (this.endTick == 0) {
            this.endTick = Objects.requireNonNull(this.maid.m_9236_().m_7654_()).m_129921_() + v;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (this.maid.m_20184_().m_82553_() > 0.1) {
            return AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE;
        }
        if (Objects.requireNonNull(this.maid.m_9236_().m_7654_()).m_129921_() < this.endTick) {
            return AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE;
        }
        return AbstractCraftActionContext.Result.SUCCESS;
    }

    @Override
    public void stop() {
    }
}

