/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.capability;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Logger;

public class MaidItemPersistDataProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<MaidPersistData> MAID_ITEM_PERSIST_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MaidPersistData>(){});
    public final MaidPersistData maidPersistData = new MaidPersistData();
    private final LazyOptional<MaidPersistData> opt = LazyOptional.of(() -> this.maidPersistData);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == MAID_ITEM_PERSIST_DATA_CAPABILITY ? this.opt.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<UUID, Data> entry : this.maidPersistData.dataMap.entrySet()) {
            tag.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().toNbt());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(key);
                this.maidPersistData.set(uuid, Data.fromNbt(nbt.m_128469_(key)));
            }
            catch (Exception e) {
                Logger.logger.error("In persist data", (Throwable)e);
            }
        }
    }

    public static MaidPersistData get(Level level) {
        return (MaidPersistData)level.getCapability(MAID_ITEM_PERSIST_DATA_CAPABILITY).orElseThrow(() -> new RuntimeException("No maid item persist data capability"));
    }

    public static class MaidPersistData {
        public Map<UUID, Data> dataMap = new ConcurrentHashMap<UUID, Data>();

        public void remove(UUID uuid) {
            this.dataMap.remove(uuid);
        }

        public void set(UUID uuid, Data data) {
            this.dataMap.put(uuid, data);
        }

        public Optional<Data> get(UUID uuid) {
            if (!this.dataMap.containsKey(uuid)) {
                return Optional.empty();
            }
            return Optional.of(this.dataMap.get(uuid));
        }

        public Optional<Data> getAndRemove(UUID uuid) {
            return Optional.ofNullable(this.dataMap.remove(uuid));
        }
    }

    public record Data(CompoundTag inventoryMemory) {
        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("inventoryMemory", (Tag)this.inventoryMemory);
            return tag;
        }

        public static Data fromNbt(CompoundTag tag) {
            return new Data(tag.m_128469_("inventoryMemory"));
        }
    }
}

