/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.capability;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.util.Conditions;

public class CraftBlockOccupyDataProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<CraftBlockOccupy> CRAFT_BLOCK_OCCUPY_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CraftBlockOccupy>(){});
    public final CraftBlockOccupy occupied = new CraftBlockOccupy();
    private final LazyOptional<CraftBlockOccupy> opt = LazyOptional.of(() -> this.occupied);

    public static CraftBlockOccupy get(Level level) {
        return (CraftBlockOccupy)level.getCapability(CRAFT_BLOCK_OCCUPY_DATA_CAPABILITY).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CRAFT_BLOCK_OCCUPY_DATA_CAPABILITY ? this.opt.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        ArrayList<OccupiedRecord> keys = new ArrayList<OccupiedRecord>(this.occupied.occupiedPos.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            CompoundTag tmp = new CompoundTag();
            tmp.m_128356_("pos", ((OccupiedRecord)keys.get((int)i)).pos.m_121878_());
            tmp.m_128405_("index", ((OccupiedRecord)keys.get((int)i)).index);
            tmp.m_128362_("maidUUID", ((OccupiedRecord)keys.get((int)i)).uuid);
            listTag.add((Object)tmp);
        }
        tag.m_128365_("occupied", (Tag)listTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag listTag = nbt.m_128437_("occupied", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tmp = listTag.m_128728_(i);
            this.occupied.addOccupy(tmp.m_128342_("maidUUID"), tmp.m_128451_("index"), BlockPos.m_122022_((long)tmp.m_128454_("pos")));
        }
    }

    public static class CraftBlockOccupy {
        public Map<OccupiedRecord, MutableInt> occupiedPos = new HashMap<OccupiedRecord, MutableInt>();

        public void addOccupy(EntityMaid maid, int index, BlockPos pos) {
            this.addOccupy(maid.m_20148_(), index, pos);
        }

        public void addOccupy(UUID maidUUID, int index, BlockPos pos) {
            OccupiedRecord occupiedRecord = new OccupiedRecord(maidUUID, pos, index);
            if (this.occupiedPos.containsKey(occupiedRecord)) {
                this.occupiedPos.get(occupiedRecord).setValue(12000);
            } else {
                this.occupiedPos.put(occupiedRecord, new MutableInt(12000));
            }
        }

        public void removeOccupyFor(EntityMaid maid, int index) {
            this.removeIf(record -> record.uuid.equals(maid.m_20148_()) && record.index == index);
        }

        public void removeAllOccupies() {
            this.occupiedPos.clear();
        }

        public void removeAllOccupiesFor(EntityMaid maid) {
            this.removeIf(occupiedRecord -> occupiedRecord.uuid.equals(maid.m_20148_()));
        }

        public void tick(ServerLevel level) {
            this.removeIf(or -> {
                EntityMaid maid;
                Entity patt4752$temp;
                return this.occupiedPos.get(or).decrementAndGet() < 0 || !((patt4752$temp = level.m_8791_(or.uuid)) instanceof EntityMaid) || !(maid = (EntityMaid)patt4752$temp).m_6084_() || !Conditions.takingRequestList(maid);
            });
        }

        protected void removeIf(Predicate<OccupiedRecord> predicate) {
            HashSet<OccupiedRecord> ks = new HashSet<OccupiedRecord>(this.occupiedPos.keySet());
            for (OccupiedRecord k : ks) {
                if (!this.occupiedPos.containsKey(k) || !predicate.test(k)) continue;
                this.occupiedPos.remove(k);
            }
        }

        public boolean isOccupiedByNonCurrent(EntityMaid maid, BlockPos pos, int index) {
            return this.occupiedPos.keySet().stream().anyMatch(or -> (or.index != index || !or.uuid.equals(maid.m_20148_())) && or.pos.equals((Object)pos));
        }

        public boolean isOccupiedByAny(BlockPos pos) {
            return this.occupiedPos.keySet().stream().anyMatch(or -> or.pos.equals((Object)pos));
        }
    }

    public record OccupiedRecord(UUID uuid, BlockPos pos, int index) {
        @Override
        public int hashCode() {
            return this.uuid.hashCode() * 3 + this.pos.hashCode() * 7 + this.index * 13;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof OccupiedRecord) {
                OccupiedRecord occupiedRecord = (OccupiedRecord)obj;
                return occupiedRecord.uuid.equals(this.uuid) && occupiedRecord.pos.equals((Object)this.pos) && occupiedRecord.index == this.index;
            }
            return false;
        }
    }
}

