/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.ai;

import com.github.tartaricacid.touhoulittlemaid.ai.service.function.IFunctionCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.response.ToolResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ArrayParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.NumberParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ObjectParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.Parameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.StringParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.RequestItemUtil;

public class StorageFetchFunction
implements IFunctionCall<StorageFetchFunctionDataList> {
    public String getId() {
        return "storage_fetch";
    }

    protected Set<Pair<String, String>> getItemKeys(List<InventoryItem> list) {
        HashSet<Pair<String, String>> keys = new HashSet<Pair<String, String>>();
        Consumer<ItemStack> add = item -> {
            @Nullable ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
            if (key != null && keys.stream().noneMatch(k -> ((String)k.getA()).equals(key.toString()))) {
                keys.add(new Pair((Object)key.toString(), (Object)item.m_41786_().getString()));
            }
        };
        list.forEach(item -> {
            ItemStack itemStack = item.itemStack;
            if (itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())) {
                CraftGuideData cgd = CraftGuideData.fromItemStack(itemStack);
                cgd.getOutput().forEach(add);
            } else {
                add.accept(itemStack);
            }
        });
        return keys;
    }

    public String getDescription(EntityMaid entityMaid) {
        return "If you need to retrieve specific items for the master, use this tool. The tool requires you to pass a list as an argument, where the list value should be a JSON array containing multiple item IDs. The response format will be: `{\"list\":[{\"itemId\":\"<itemID>\",\"count\":<quantity>}...]}`. The item ID must follow the namespace:id format, and the count value must not exceed ten. Item IDs can be obtained through the warehouse inventory query tool. After using this tool, a task checklist will be generated. Items being added to the task checklist does NOT mean they have been acquired yet - it only indicates the tool will search for them later. The master will only receive the items after all tasks in the checklist are completed. You will receive information about both items already added to the task list and those not yet added, including their IDs and names. Always refer to items by their names rather than their IDs. You must get ItemId from `get_storage` tool.";
    }

    public Parameter addParameters(ObjectParameter objectParameter, EntityMaid entityMaid) {
        ObjectParameter singleParam = ObjectParameter.create();
        singleParam.addProperties("itemId", (Parameter)StringParameter.create().setPattern("[a-zA-Z0-9_]+:[a-zA-Z0-9_]+"));
        singleParam.addProperties("count", (Parameter)NumberParameter.create());
        ArrayParameter arrayParameter = ArrayParameter.create().setItems((Parameter)singleParam);
        objectParameter.addProperties("list", (Parameter)arrayParameter);
        return objectParameter;
    }

    public Codec<StorageFetchFunctionDataList> codec() {
        return StorageFetchFunctionDataList.CODEC;
    }

    public boolean addToChatCompletion(EntityMaid maid, ChatCompletion chatCompletion) {
        return maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID);
    }

    public ToolResponse onToolCall(StorageFetchFunctionDataList storageFetchFunctionDataList, EntityMaid entityMaid) {
        Set<Pair<String, String>> itemKeys = this.getItemKeys(MemoryUtil.getViewedInventory(entityMaid).flatten());
        StringBuilder message = new StringBuilder();
        MutableBoolean partial = new MutableBoolean(false);
        List<StorageFetchFunctionData> storageFetchFunctionData = storageFetchFunctionDataList.list;
        List<ItemStack> list = storageFetchFunctionData.stream().map(i -> {
            ResourceLocation resourceLocation = new ResourceLocation(i.itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            if (item == null) {
                partial.setTrue();
                message.append("Task NOT added: [").append(i.itemId).append("]:").append("unknown There's no corresponding item.\n");
                return null;
            }
            if (itemKeys.stream().noneMatch(ik -> ((String)ik.getA()).equals(i.itemId))) {
                partial.setTrue();
                message.append("Task NOT added: [").append(i.itemId).append("]").append(item.m_7968_().m_41786_()).append(" Not exist in warehouse\n");
                return null;
            }
            message.append("Task added: [").append(i.itemId).append("]").append(item.m_7968_().m_41786_()).append("\n");
            return item.m_7968_().m_255036_(i.count);
        }).filter(Objects::nonNull).toList();
        if (list.isEmpty()) {
            message.append("Fail! Nothing to gather.");
        } else {
            CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
            if (InvUtil.hasAnyFree((IItemHandler)availableInv)) {
                InvUtil.tryPlace((IItemHandler)availableInv, RequestItemUtil.makeVirtualItemStack(list, null, (Entity)entityMaid.m_269323_(), "AI"));
                if (partial.getValue().booleanValue()) {
                    message.append("Partial items was added to the request task.");
                } else {
                    message.append("All items was added to the request task.");
                }
                message.append("Please always refer to items by their name and not their ID. The tool will go look for the item later, and the owner will not get the item until all the tasks in the tool's task list have been completed.");
            } else {
                return new ToolResponse("Fail! No free space in backpack");
            }
        }
        return new ToolResponse(message.toString());
    }

    public record StorageFetchFunctionDataList(List<StorageFetchFunctionData> list) {
        public static Codec<StorageFetchFunctionDataList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(StorageFetchFunctionData.CODEC).fieldOf("list").forGetter(StorageFetchFunctionDataList::list)).apply((Applicative)instance, StorageFetchFunctionDataList::new));
    }

    public record StorageFetchFunctionData(String itemId, int count) {
        public static Codec<StorageFetchFunctionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("itemId").forGetter(StorageFetchFunctionData::itemId), (App)Codec.INT.fieldOf("count").forGetter(StorageFetchFunctionData::count)).apply((Applicative)instance, StorageFetchFunctionData::new));
    }
}

