/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.recipe;

import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;

public class PotRecipe
implements Recipe<PotBlockEntity> {
    public static final int RECIPES_SIZE = 9;
    private final ResourceLocation id;
    private final int time;
    private final int stirFryCount;
    private final boolean needBowl;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;

    public PotRecipe(ResourceLocation id, int time, int stirFryCount, boolean needBowl, List<Ingredient> ingredients, ItemStack result) {
        this.id = id;
        this.time = time;
        this.stirFryCount = stirFryCount;
        this.needBowl = needBowl;
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])this.fillInputs(ingredients));
        this.result = result;
    }

    public boolean matches(PotBlockEntity pContainer, Level pLevel) {
        return RecipeMatcher.findMatches(pContainer.getItems(), this.ingredients) != null;
    }

    public ItemStack assemble(PotBlockEntity pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public int getTime() {
        return this.time;
    }

    public int getStirFryCount() {
        return this.stirFryCount;
    }

    public boolean isNeedBowl() {
        return this.needBowl;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.POT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.POT_RECIPE;
    }

    public boolean m_5598_() {
        return true;
    }

    private Ingredient[] fillInputs(List<Ingredient> inputs) {
        Ingredient[] newInputs = new Ingredient[9];
        for (int i = 0; i < 9; ++i) {
            newInputs[i] = i < inputs.size() ? inputs.get(i) : Ingredient.f_43901_;
        }
        return newInputs;
    }
}

