/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.init.registry;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModFoods;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteAnimateTicks;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class FoodBiteRegistry {
    public static final Map<ResourceLocation, FoodData> FOOD_DATA_MAP = Maps.newHashMap();
    public static ResourceLocation DARK_CUISINE;
    public static ResourceLocation SUSPICIOUS_STIR_FRY;
    public static ResourceLocation SLIME_BALL_MEAL;
    public static ResourceLocation FONDANT_PIE;
    public static ResourceLocation DONGPO_PORK;
    public static ResourceLocation FONDANT_SPIDER_EYE;
    public static ResourceLocation CHORUS_FRIED_EGG;
    public static ResourceLocation BRAISED_FISH;
    public static ResourceLocation GOLDEN_SALAD;
    public static ResourceLocation SPICY_CHICKEN;
    public static ResourceLocation YAKITORI;
    public static ResourceLocation CRYSTAL_LAMB_CHOP;
    public static ResourceLocation NETHER_STYLE_SASHIMI;
    public static ResourceLocation PAN_SEARED_KNIGHT_STEAK;
    public static ResourceLocation STARGAZY_PIE;
    public static ResourceLocation SWEET_AND_SOUR_ENDER_PEARLS;
    public static ResourceLocation BLAZE_LAMB_CHOP;
    public static ResourceLocation FROST_LAMB_CHOP;
    public static ResourceLocation END_STYLE_SASHIMI;
    public static ResourceLocation DESERT_STYLE_SASHIMI;
    public static ResourceLocation TUNDRA_STYLE_SASHIMI;
    public static ResourceLocation COLD_STYLE_SASHIMI;

    public static void init() {
        FoodBiteRegistry registry = new FoodBiteRegistry();
        DARK_CUISINE = registry.registerFoodData("dark_cuisine", FoodData.maxBites(3).setBlockFood(2, 0.1f).setBlockFood(ModFoods.DARK_CUISINE_BLOCK).setItemFood(ModFoods.DARK_CUISINE_ITEM).setAnimateTick(FoodBiteAnimateTicks.DARK_CUISINE_ANIMATE_TICK));
        SUSPICIOUS_STIR_FRY = registry.registerFoodData("suspicious_stir_fry", FoodData.maxBites(1).setBlockFood(2, 0.1f).setBlockFood(ModFoods.SUSPICIOUS_STIR_FRY).setItemFood(ModFoods.SUSPICIOUS_STIR_FRY).setAnimateTick(FoodBiteAnimateTicks.SUSPICIOUS_STIR_FRY_ANIMATE_TICK));
        SLIME_BALL_MEAL = registry.registerFoodData("slime_ball_meal", FoodData.maxBites(3).setFood(3, 0.2f));
        FONDANT_PIE = registry.registerFoodData("fondant_pie", FoodData.maxBites(4).setFood(4, 0.2f));
        DONGPO_PORK = registry.registerFoodData("dongpo_pork", FoodData.maxBites(3).setFood(3, 0.2f).addLootItems(new ItemLike[]{Items.f_41911_}));
        FONDANT_SPIDER_EYE = registry.registerFoodData("fondant_spider_eye", FoodData.maxBites(4).setFood(4, 0.2f));
        CHORUS_FRIED_EGG = registry.registerFoodData("chorus_fried_egg", FoodData.maxBites(3).setFood(3, 0.2f));
        BRAISED_FISH = registry.registerFoodData("braised_fish", FoodData.maxBites(4).setFood(4, 0.2f).addLootItems(new ItemLike[]{Items.f_42500_, Items.f_42499_}));
        GOLDEN_SALAD = registry.registerFoodData("golden_salad", FoodData.maxBites(6).setFood(6, 0.2f));
        SPICY_CHICKEN = registry.registerFoodData("spicy_chicken", FoodData.maxBites(4).setFood(4, 0.2f));
        YAKITORI = registry.registerFoodData("yakitori", FoodData.maxBites(4).setFood(4, 0.2f));
        CRYSTAL_LAMB_CHOP = registry.registerFoodData("crystal_lamb_chop", FoodData.maxBites(3).setFood(3, 0.2f).addLootItems(new ItemLike[]{Items.f_151049_}));
        NETHER_STYLE_SASHIMI = registry.registerFoodData("nether_style_sashimi", FoodData.maxBites(4).setFood(4, 0.2f).addLootItems(new ItemLike[]{Items.f_41954_, Items.f_41955_}));
        PAN_SEARED_KNIGHT_STEAK = registry.registerFoodData("pan_seared_knight_steak", FoodData.maxBites(4).setFood(4, 0.2f).addLootItems(new ItemLike[]{Items.f_42500_, Items.f_42499_}));
        STARGAZY_PIE = registry.registerFoodData("stargazy_pie", FoodData.maxBites(4).setFood(4, 0.2f));
        SWEET_AND_SOUR_ENDER_PEARLS = registry.registerFoodData("sweet_and_sour_ender_pearls", FoodData.maxBites(3).setFood(3, 0.2f));
        BLAZE_LAMB_CHOP = registry.registerFoodData("blaze_lamb_chop", FoodData.maxBites(3).setFood(3, 0.2f).addLootItems(new ItemLike[]{Items.f_42585_}));
        FROST_LAMB_CHOP = registry.registerFoodData("frost_lamb_chop", FoodData.maxBites(3).setFood(3, 0.2f).addLootItems(new ItemLike[]{Items.f_42363_}));
        END_STYLE_SASHIMI = registry.registerFoodData("end_style_sashimi", FoodData.maxBites(4).setFood(4, 0.2f).addLootItems(new ItemLike[]{Items.f_42730_}));
        DESERT_STYLE_SASHIMI = registry.registerFoodData("desert_style_sashimi", FoodData.maxBites(4).setFood(4, 0.2f).addLootItems(new ItemLike[]{Items.f_41982_}));
        TUNDRA_STYLE_SASHIMI = registry.registerFoodData("tundra_style_sashimi", FoodData.maxBites(4).setFood(4, 0.2f));
        COLD_STYLE_SASHIMI = registry.registerFoodData("cold_style_sashimi", FoodData.maxBites(4).setFood(4, 0.2f).addLootItems(new ItemLike[]{Items.f_42452_, Items.f_42452_}));
    }

    public ResourceLocation registerFoodData(ResourceLocation foodName, FoodData data) {
        FOOD_DATA_MAP.put(foodName, data);
        return foodName;
    }

    public ResourceLocation registerFoodData(String foodName, FoodData data) {
        ResourceLocation id = FoodBiteRegistry.mcLoc(foodName);
        FOOD_DATA_MAP.put(id, data);
        return id;
    }

    public static ResourceLocation mcLoc(String name) {
        return new ResourceLocation("kaleidoscope_cookery", name);
    }

    public static Item getItem(ResourceLocation name) {
        return (Item)ForgeRegistries.ITEMS.getValue(name);
    }

    public static Block getBlock(ResourceLocation name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(name);
    }

    public static final class FoodData {
        private final int maxBites;
        private final List<ItemLike> lootItems = Lists.newArrayList();
        private FoodProperties blockFood = new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_();
        private FoodProperties itemFood = new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_();
        @Nullable
        private FoodBiteAnimateTicks.AnimateTick animateTick = null;

        private FoodData(int maxBites) {
            this.maxBites = maxBites;
            this.lootItems.add((ItemLike)Items.f_42399_);
        }

        public static FoodData maxBites(int maxBites) {
            return new FoodData(maxBites);
        }

        public FoodData setFood(int nutrition, float saturationModifier) {
            int count = this.maxBites - 1;
            this.blockFood = new FoodProperties.Builder().m_38760_(nutrition / count).m_38758_(saturationModifier / (float)count).m_38765_().m_38767_();
            this.itemFood = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturationModifier).m_38765_().m_38767_();
            return this;
        }

        public FoodData setBlockFood(FoodProperties blockFood) {
            this.blockFood = blockFood;
            return this;
        }

        public FoodData setBlockFood(int nutrition, float saturationModifier) {
            this.blockFood = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturationModifier).m_38765_().m_38767_();
            return this;
        }

        public FoodData setItemFood(FoodProperties itemFood) {
            this.itemFood = itemFood;
            return this;
        }

        public FoodData setItemFood(int nutrition, float saturationModifier) {
            this.itemFood = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturationModifier).m_38765_().m_38767_();
            return this;
        }

        public FoodData setAnimateTick(FoodBiteAnimateTicks.AnimateTick animateTick) {
            this.animateTick = animateTick;
            return this;
        }

        public FoodData addLootItems(ItemLike ... lootItems) {
            this.lootItems.addAll(Arrays.stream(lootItems).toList());
            return this;
        }

        public int maxBites() {
            return this.maxBites;
        }

        @Nullable
        public FoodBiteAnimateTicks.AnimateTick animateTick() {
            return this.animateTick;
        }

        public List<ItemLike> getLootItems() {
            return this.lootItems;
        }

        public FoodProperties blockFood() {
            return this.blockFood;
        }

        public FoodProperties itemFood() {
            return this.itemFood;
        }
    }
}

