/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ScarecrowEntity
extends LivingEntity {
    public static final EntityType<ScarecrowEntity> TYPE = EntityType.Builder.m_20704_(ScarecrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 2.375f).m_20702_(10).m_20712_("scarecrow");
    private static final EntityDataAccessor<CompoundTag> DATA_SHOULDER = SynchedEntityData.m_135353_(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final Predicate<Entity> RIDABLE_MINECARTS = e -> {
        AbstractMinecart minecart;
        return e instanceof AbstractMinecart && (minecart = (AbstractMinecart)e).canBeRidden();
    };
    private static final Predicate<Entity> SHOULDER_RIDING_ENTITY = e -> {
        ShoulderRidingEntity entity;
        return e instanceof ShoulderRidingEntity && !(entity = (ShoulderRidingEntity)e).m_21827_() && entity.m_29897_();
    };
    private static final String HAND_ITEMS_TAG = "HandItems";
    private static final String ARMOR_ITEMS_TAG = "ArmorItems";
    private static final String SHOULDER_ENTITY_TAG = "ShoulderEntity";
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public long lastHit;
    private int cooldown;
    private long timeEntitySatOnShoulder;

    public ScarecrowEntity(EntityType<ScarecrowEntity> type, Level level) {
        super(type, level);
        this.m_274367_(0.0f);
    }

    public ScarecrowEntity(Level level, double pX, double pY, double pZ) {
        this(TYPE, level);
        this.m_6034_(pX, pY, pZ);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHOULDER, (Object)new CompoundTag());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_150930_(Items.f_42656_)) {
            return InteractionResult.PASS;
        }
        if (player.m_5833_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_9236_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (this.cooldown > 0) {
            return InteractionResult.PASS;
        }
        if (this.isClickHand(vec3)) {
            return this.handleHandItems(player, itemInHand);
        }
        if (this.isClickHead(vec3)) {
            return this.handleHeadItems(player, itemInHand);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleHeadItems(Player player, ItemStack itemInHand) {
        BlockItem blockItem;
        this.cooldown = 5;
        ItemStack headItem = this.m_6844_(EquipmentSlot.HEAD);
        if (itemInHand.m_41619_() && !headItem.m_41619_()) {
            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)headItem);
            return InteractionResult.SUCCESS;
        }
        Item item = itemInHand.m_41720_();
        if (!(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).m_40614_()) instanceof SkullBlock)) {
            return InteractionResult.PASS;
        }
        SkullBlock skullBlock = (SkullBlock)item;
        if (player.m_150110_().f_35937_ && headItem.m_41619_()) {
            this.m_8061_(EquipmentSlot.HEAD, itemInHand.m_255036_(1));
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12013_, this.m_5720_());
            return InteractionResult.SUCCESS;
        }
        if (!itemInHand.m_41619_() && itemInHand.m_41613_() > 1) {
            if (headItem.m_41619_()) {
                this.m_8061_(EquipmentSlot.HEAD, itemInHand.m_41620_(1));
                this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12013_, this.m_5720_());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        this.m_8061_(EquipmentSlot.HEAD, itemInHand);
        this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12013_, this.m_5720_());
        player.m_21008_(InteractionHand.MAIN_HAND, headItem);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleHandItems(Player player, ItemStack itemInHand) {
        BlockItem blockItem;
        this.cooldown = 5;
        if (itemInHand.m_41619_()) {
            ItemStack mainhand = this.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offhand = this.m_21120_(InteractionHand.OFF_HAND);
            if (!mainhand.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)mainhand);
                return InteractionResult.SUCCESS;
            }
            if (!offhand.m_41619_()) {
                this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)offhand);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        Item item = itemInHand.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof LanternBlock && this.swapHand(InteractionHand.OFF_HAND, player, itemInHand)) {
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12028_, this.m_5720_());
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.m_41720_().m_41465_() && this.swapHand(InteractionHand.MAIN_HAND, player, itemInHand)) {
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12013_, this.m_5720_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean swapHand(InteractionHand hand, Player player, ItemStack itemInHand) {
        ItemStack scarecrowStack = this.m_21120_(hand);
        if (player.m_150110_().f_35937_ && scarecrowStack.m_41619_() && !itemInHand.m_41619_()) {
            this.m_21008_(hand, itemInHand.m_255036_(1));
            return true;
        }
        if (!itemInHand.m_41619_() && itemInHand.m_41613_() > 1) {
            if (scarecrowStack.m_41619_()) {
                this.m_21008_(hand, itemInHand.m_41620_(1));
                return true;
            }
            return false;
        }
        this.m_21008_(hand, itemInHand);
        player.m_21008_(InteractionHand.MAIN_HAND, scarecrowStack);
        return true;
    }

    private boolean isClickHand(Vec3 vector) {
        return 1.0625 <= vector.f_82480_ && vector.f_82480_ <= 1.588235294117647;
    }

    private boolean isClickHead(Vec3 vector) {
        return 1.588235294117647 < vector.f_82480_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_6074_();
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            this.brokenByAnything(source);
            this.m_6074_();
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35938_) {
                return false;
            }
        }
        if (source.m_19390_()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.m_6074_();
            return false;
        }
        long gameTime = this.m_9236_().m_46467_();
        if (gameTime - this.lastHit > 5L) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)32);
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            this.lastHit = gameTime;
            if (!this.getShoulderEntity().m_128456_()) {
                this.removeEntitiesOnShoulder();
            }
        } else {
            this.brokenByPlayer(source);
            this.showBreakingParticles();
            this.m_6074_();
        }
        return true;
    }

    public void m_7822_(byte id) {
        if (id == 32) {
            if (this.m_9236_().f_46443_) {
                this.lastHit = this.m_9236_().m_46467_();
            }
        } else {
            super.m_7822_(id);
        }
    }

    private void brokenByPlayer(DamageSource source) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SCARECROW.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)stack);
        this.brokenByAnything(source);
    }

    private void brokenByAnything(DamageSource source) {
        ItemStack stack;
        int i;
        this.playBrokenSound();
        this.m_6668_(source);
        for (i = 0; i < this.handItems.size(); ++i) {
            stack = (ItemStack)this.handItems.get(i);
            if (stack.m_41619_()) continue;
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_().m_7494_(), (ItemStack)stack);
            this.handItems.set(i, (Object)ItemStack.f_41583_);
        }
        for (i = 0; i < this.armorItems.size(); ++i) {
            stack = (ItemStack)this.armorItems.get(i);
            if (stack.m_41619_()) continue;
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_().m_7494_(), (ItemStack)stack);
            this.armorItems.set(i, (Object)ItemStack.f_41583_);
        }
    }

    private void playBrokenSound() {
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    private void showBreakingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_());
            serverLevel.m_8767_((ParticleOptions)particleOption, this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private boolean setEntityOnShoulder(CompoundTag tag) {
        if (this.canEntityOnShoulder()) {
            this.setShoulderEntity(tag);
            this.timeEntitySatOnShoulder = this.m_9236_().m_46467_();
            return true;
        }
        return false;
    }

    private void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.m_9236_().m_46467_()) {
            this.respawnEntityOnShoulder(this.getShoulderEntity());
            this.setShoulderEntity(new CompoundTag());
        }
    }

    private void respawnEntityOnShoulder(CompoundTag tag) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!tag.m_128456_()) {
                EntityType.m_20642_((CompoundTag)tag, (Level)this.m_9236_()).ifPresent(entity -> {
                    entity.m_6034_(this.m_20185_(), this.m_20186_() + 1.675, this.m_20189_());
                    serverLevel.m_8847_(entity);
                });
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128365_(HAND_ITEMS_TAG, (Tag)new ItemStackHandler(this.handItems).serializeNBT());
        tag.m_128365_(ARMOR_ITEMS_TAG, (Tag)new ItemStackHandler(this.armorItems).serializeNBT());
        if (!this.getShoulderEntity().m_128456_()) {
            tag.m_128365_(SHOULDER_ENTITY_TAG, (Tag)this.getShoulderEntity());
        }
    }

    public void m_7378_(CompoundTag tag) {
        ItemStack stack;
        int i;
        ItemStackHandler handler;
        super.m_7378_(tag);
        if (tag.m_128441_(HAND_ITEMS_TAG)) {
            handler = new ItemStackHandler();
            handler.deserializeNBT(tag.m_128469_(HAND_ITEMS_TAG));
            for (i = 0; i < this.handItems.size(); ++i) {
                stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                this.handItems.set(i, (Object)stack);
            }
        }
        if (tag.m_128441_(ARMOR_ITEMS_TAG)) {
            handler = new ItemStackHandler();
            handler.deserializeNBT(tag.m_128469_(ARMOR_ITEMS_TAG));
            for (i = 0; i < this.armorItems.size(); ++i) {
                stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                this.armorItems.set(i, (Object)stack);
            }
        }
        if (tag.m_128425_(SHOULDER_ENTITY_TAG, 10)) {
            this.setShoulderEntity(tag.m_128469_(SHOULDER_ENTITY_TAG));
        }
    }

    protected float m_5632_(float yRot, float animStep) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    public void m_5618_(float offset) {
        this.f_20884_ = this.f_19859_ = offset;
        this.f_20886_ = this.f_20885_ = offset;
    }

    public void m_5616_(float rotation) {
        this.f_20884_ = this.f_19859_ = rotation;
        this.f_20886_ = this.f_20885_ = rotation;
    }

    public void m_6074_() {
        if (!this.getShoulderEntity().m_128456_()) {
            this.removeEntitiesOnShoulder();
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), RIDABLE_MINECARTS);
        for (Entity entity : list) {
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
            return;
        }
        if (this.canEntityOnShoulder()) {
            list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(2.0), SHOULDER_RIDING_ENTITY);
            for (Entity entity : list) {
                ShoulderRidingEntity shoulderEntity;
                if (!(this.m_20280_(entity) <= 1.5) || !(entity instanceof ShoulderRidingEntity) || !this.setEntityOnShoulder(shoulderEntity = (ShoulderRidingEntity)entity)) continue;
                return;
            }
        }
    }

    private boolean setEntityOnShoulder(ShoulderRidingEntity entity) {
        CompoundTag tag = new CompoundTag();
        String id = entity.m_20078_();
        if (id == null) {
            return false;
        }
        tag.m_128359_("id", id);
        entity.m_20240_(tag);
        if (this.setEntityOnShoulder(tag)) {
            entity.m_146870_();
            return true;
        }
        return false;
    }

    private boolean canEntityOnShoulder() {
        return !this.m_20159_() && this.m_20096_() && !this.m_20069_() && !this.f_146808_ && this.getShoulderEntity().m_128456_();
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return switch (slot.m_20743_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.Type.HAND -> (ItemStack)this.handItems.get(slot.m_20749_());
            case EquipmentSlot.Type.ARMOR -> (ItemStack)this.armorItems.get(slot.m_20749_());
        };
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        this.m_181122_(stack);
        switch (slot.m_20743_()) {
            case HAND: {
                this.m_238392_(slot, (ItemStack)this.handItems.set(slot.m_20749_(), (Object)stack), stack);
                break;
            }
            case ARMOR: {
                this.m_238392_(slot, (ItemStack)this.armorItems.set(slot.m_20749_(), (Object)stack), stack);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7313_(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (this.m_9236_().m_7966_(player, this.m_20183_())) return false;
        return true;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11682_, SoundEvents.f_11682_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11683_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.SCARECROW.get());
    }

    public CompoundTag getShoulderEntity() {
        return (CompoundTag)this.f_19804_.m_135370_(DATA_SHOULDER);
    }

    public void setShoulderEntity(CompoundTag tag) {
        this.f_19804_.m_135381_(DATA_SHOULDER, (Object)tag);
    }
}

