/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen;

import com.github.ysbbbbbb.kaleidoscopecookery.block.ChiliRistraBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.EnamelBasinBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.loot.AdvanceBlockMatchTool;
import com.github.ysbbbbbb.kaleidoscopecookery.loot.AdvanceEntityMatchTool;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTableGenerator {

    public static class EntityLootTables
    extends EntityLootSubProvider {
        public final Set<EntityType<?>> knownEntities = Sets.newHashSet();

        protected EntityLootTables() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> output) {
            super.m_245126_(output);
            ItemPredicate hasKnife = ItemPredicate.Builder.m_45068_().m_204145_(TagMod.KITCHEN_KNIFE).m_45077_();
            LootItemCondition.Builder toolMatches = AdvanceEntityMatchTool.toolMatches(EquipmentSlot.MAINHAND, hasKnife);
            LootItemConditionalFunction.Builder count = SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f));
            LootingEnchantFunction.Builder looting = LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
            LootPoolSingletonContainer.Builder oil = LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OIL.get())).m_79078_((LootItemFunction.Builder)count).m_79078_((LootItemFunction.Builder)looting);
            LootTable.Builder lessOil = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)oil).m_79080_(toolMatches));
            LootTable.Builder moreOil = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)oil).m_79080_(toolMatches));
            output.accept(this.modLoc("pig"), lessOil);
            output.accept(this.modLoc("piglin"), moreOil);
            output.accept(this.modLoc("piglin_brute"), moreOil);
            output.accept(this.modLoc("hoglin"), moreOil);
        }

        public void m_246942_() {
        }

        protected boolean m_245552_(EntityType<?> type) {
            return true;
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return this.knownEntities.stream();
        }

        protected void m_245309_(EntityType<?> type, LootTable.Builder builder) {
            this.m_247520_(type, type.m_20677_(), builder);
        }

        protected void m_247520_(EntityType<?> type, ResourceLocation lootTable, LootTable.Builder builder) {
            super.m_247520_(type, lootTable, builder);
            this.knownEntities.add(type);
        }

        public ResourceLocation modLoc(String name) {
            return new ResourceLocation("kaleidoscope_cookery", name);
        }
    }

    public static class BlockLootTables
    extends BlockLootSubProvider {
        public final Set<Block> knownBlocks = new HashSet<Block>();

        public BlockLootTables() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245660_() {
            this.m_245724_((Block)ModBlocks.STOVE.get());
            this.m_245724_((Block)ModBlocks.POT.get());
            this.m_245724_((Block)ModBlocks.CHOPPING_BOARD.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_OAK.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_SPRUCE.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_ACACIA.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_BAMBOO.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_BIRCH.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_CHERRY.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_CRIMSON.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_DARK_OAK.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_JUNGLE.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_MANGROVE.get());
            this.m_245724_((Block)ModBlocks.COOK_STOOL_WARPED.get());
            this.m_245724_((Block)ModBlocks.CHAIR_OAK.get());
            this.m_245724_((Block)ModBlocks.CHAIR_SPRUCE.get());
            this.m_245724_((Block)ModBlocks.CHAIR_ACACIA.get());
            this.m_245724_((Block)ModBlocks.CHAIR_BAMBOO.get());
            this.m_245724_((Block)ModBlocks.CHAIR_BIRCH.get());
            this.m_245724_((Block)ModBlocks.CHAIR_CHERRY.get());
            this.m_245724_((Block)ModBlocks.CHAIR_CRIMSON.get());
            this.m_245724_((Block)ModBlocks.CHAIR_DARK_OAK.get());
            this.m_245724_((Block)ModBlocks.CHAIR_JUNGLE.get());
            this.m_245724_((Block)ModBlocks.CHAIR_MANGROVE.get());
            this.m_245724_((Block)ModBlocks.CHAIR_WARPED.get());
            this.m_245724_((Block)ModBlocks.TABLE_OAK.get());
            this.m_245724_((Block)ModBlocks.TABLE_SPRUCE.get());
            this.m_245724_((Block)ModBlocks.TABLE_ACACIA.get());
            this.m_245724_((Block)ModBlocks.TABLE_BAMBOO.get());
            this.m_245724_((Block)ModBlocks.TABLE_BIRCH.get());
            this.m_245724_((Block)ModBlocks.TABLE_CHERRY.get());
            this.m_245724_((Block)ModBlocks.TABLE_CRIMSON.get());
            this.m_245724_((Block)ModBlocks.TABLE_DARK_OAK.get());
            this.m_245724_((Block)ModBlocks.TABLE_JUNGLE.get());
            this.m_245724_((Block)ModBlocks.TABLE_MANGROVE.get());
            this.m_245724_((Block)ModBlocks.TABLE_WARPED.get());
            this.m_245724_((Block)ModBlocks.STOCKPOT.get());
            this.m_245724_((Block)ModBlocks.KITCHENWARE_RACKS.get());
            this.m_245724_((Block)ModBlocks.STRAW_BLOCK.get());
            this.m_247577_((Block)ModBlocks.TOMATO_CROP.get(), this.m_245238_((Block)ModBlocks.TOMATO_CROP.get(), (Item)ModItems.TOMATO.get(), (Item)ModItems.TOMATO_SEED.get(), this.createCropBuilder((Block)ModBlocks.TOMATO_CROP.get())));
            LootItemCondition.Builder chiliBuilder = this.createCropBuilder((Block)ModBlocks.CHILI_CROP.get());
            LootPoolSingletonContainer.Builder greenChili = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.GREEN_CHILI.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.2f));
            this.m_247577_((Block)ModBlocks.CHILI_CROP.get(), this.m_245238_((Block)ModBlocks.CHILI_CROP.get(), (Item)ModItems.RED_CHILI.get(), (Item)ModItems.CHILI_SEED.get(), chiliBuilder).m_79161_(LootPool.m_79043_().m_79080_(chiliBuilder).m_79076_((LootPoolEntryContainer.Builder)greenChili)));
            LootItemCondition.Builder lettuceBuilder = this.createCropBuilder((Block)ModBlocks.LETTUCE_CROP.get());
            LootPoolSingletonContainer.Builder caterpillar = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CATERPILLAR.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.1f));
            this.m_247577_((Block)ModBlocks.LETTUCE_CROP.get(), this.m_245238_((Block)ModBlocks.LETTUCE_CROP.get(), (Item)ModItems.LETTUCE.get(), (Item)ModItems.LETTUCE_SEED.get(), lettuceBuilder).m_79161_(LootPool.m_79043_().m_79080_(lettuceBuilder).m_79076_((LootPoolEntryContainer.Builder)caterpillar)));
            Item riceSeed = (Item)ModItems.WILD_RICE_SEED.get();
            LootItemCondition.Builder riceCropBuilder = this.createRiceCropBuilder();
            LootItemConditionalFunction.Builder countFunction = SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f));
            LootPool.Builder ricePanicle = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RICE_PANICLE.get())).m_79080_(riceCropBuilder)).m_79078_((LootItemFunction.Builder)countFunction).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)riceSeed)));
            LootPool.Builder extraRiceSeeds = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)riceSeed)).m_79080_(riceCropBuilder).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3));
            this.m_247577_((Block)ModBlocks.RICE_CROP.get(), (LootTable.Builder)this.m_246108_((ItemLike)ModBlocks.RICE_CROP.get(), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(ricePanicle).m_79161_(extraRiceSeeds)));
            FoodBiteRegistry.FOOD_DATA_MAP.forEach(this::dropFoodBite);
            this.m_247577_((Block)ModBlocks.ENAMEL_BASIN.get(), this.createEnamelBasinLootTable());
            this.m_247577_((Block)ModBlocks.CHILI_RISTRA.get(), this.createChiliRistraLootTable());
        }

        private LootTable.Builder createChiliRistraLootTable() {
            LootPool.Builder builder = LootPool.m_79043_();
            StatePropertiesPredicate.Builder isSheared = StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)ChiliRistraBlock.SHEARED, true);
            LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.CHILI_RISTRA.get())).m_81784_(isSheared);
            LootItemConditionalFunction.Builder normalDrop = SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)6.0f));
            LootItemConditionalFunction.Builder shearedDrop = SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f));
            LootPoolSingletonContainer.Builder normalLoot = LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RED_CHILI.get())).m_79078_((LootItemFunction.Builder)normalDrop);
            LootPoolSingletonContainer.Builder shearedLoot = LootItem.m_79579_((ItemLike)((ItemLike)ModItems.RED_CHILI.get())).m_79078_((LootItemFunction.Builder)shearedDrop);
            builder.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)shearedLoot.m_79080_((LootItemCondition.Builder)condition)).m_7170_((LootPoolEntryContainer.Builder)normalLoot));
            return LootTable.m_79147_().m_79161_(builder.m_79080_(ExplosionCondition.m_81661_()));
        }

        private LootTable.Builder createEnamelBasinLootTable() {
            LootPool.Builder oilDrop = LootPool.m_79043_();
            for (int i = 1; i <= 11; ++i) {
                StatePropertiesPredicate.Builder property = StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)EnamelBasinBlock.OIL_COUNT, i);
                LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.ENAMEL_BASIN.get())).m_81784_(property);
                int dropCount = i / 2;
                if (dropCount <= 0) continue;
                LootItemConditionalFunction.Builder count = SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)dropCount));
                oilDrop.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.OIL.get())).m_79080_((LootItemCondition.Builder)condition)).m_79078_((LootItemFunction.Builder)count));
            }
            LootPool.Builder bucketDrop = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42446_));
            return LootTable.m_79147_().m_79161_(oilDrop.m_79080_(ExplosionCondition.m_81661_())).m_79161_(bucketDrop.m_79080_(ExplosionCondition.m_81661_()));
        }

        private LootItemCondition.Builder createCropBuilder(Block cropBlock) {
            StatePropertiesPredicate.Builder property = StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7);
            return LootItemBlockStatePropertyCondition.m_81769_((Block)cropBlock).m_81784_(property);
        }

        private LootItemCondition.Builder createRiceCropBuilder() {
            StatePropertiesPredicate.Builder property = StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7).m_67694_((Property)RiceCropBlock.LOCATION, 0);
            return LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.RICE_CROP.get())).m_81784_(property);
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> output) {
            super.m_245126_(output);
            LootPoolSingletonContainer.Builder<?> tomato = this.getSeed((ItemLike)ModItems.TOMATO_SEED.get());
            LootPoolSingletonContainer.Builder<?> chili = this.getSeed((ItemLike)ModItems.CHILI_SEED.get());
            LootPoolSingletonContainer.Builder<?> lettuce = this.getSeed((ItemLike)ModItems.LETTUCE_SEED.get());
            LootPoolSingletonContainer.Builder<?> rice = this.getSeed((ItemLike)ModItems.WILD_RICE_SEED.get());
            LootTable.Builder dropSeed = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(tomato).m_79076_(chili).m_79076_(lettuce).m_79076_(rice));
            output.accept(this.modLoc("straw_hat_seed_drop"), dropSeed);
        }

        private LootPoolSingletonContainer.Builder<?> getSeed(ItemLike item) {
            ItemPredicate hasHat = ItemPredicate.Builder.m_45068_().m_204145_(TagMod.STRAW_HAT).m_45077_();
            LootItemCondition.Builder hatMatches = AdvanceBlockMatchTool.toolMatches(EquipmentSlot.HEAD, hasHat);
            return ((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.125f))).m_79080_(hatMatches)).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2));
        }

        private void dropFoodBite(ResourceLocation id, FoodBiteRegistry.FoodData data) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            Item food = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (!(block instanceof FoodBiteBlock)) {
                return;
            }
            FoodBiteBlock foodBiteBlock = (FoodBiteBlock)block;
            if (food == null) {
                return;
            }
            ConstantValue exactly = ConstantValue.m_165692_((float)1.0f);
            StatePropertiesPredicate.Builder notBite = StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)foodBiteBlock.getBites(), 0);
            LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.m_81769_((Block)foodBiteBlock).m_81784_(notBite);
            LootTable.Builder lootTable = LootTable.m_79147_();
            for (int i = 0; i < data.getLootItems().size(); ++i) {
                ItemLike itemLike = data.getLootItems().get(i);
                LootPool.Builder rolls = LootPool.m_79043_().m_165133_((NumberProvider)exactly).m_79080_(ExplosionCondition.m_81661_());
                if (i == 0) {
                    rolls.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)food).m_79080_((LootItemCondition.Builder)builder)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemLike)));
                } else {
                    rolls.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)EmptyLootItem.m_79533_().m_79080_((LootItemCondition.Builder)builder)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemLike)));
                }
                lootTable.m_79161_(rolls);
            }
            this.m_247577_(block, lootTable);
        }

        public void m_247577_(Block block, LootTable.Builder builder) {
            this.knownBlocks.add(block);
            super.m_247577_(block, builder);
        }

        public Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        public ResourceLocation modLoc(String name) {
            return new ResourceLocation("kaleidoscope_cookery", name);
        }
    }
}

