/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen;

import com.github.ysbbbbbb.kaleidoscopecookery.datagen.AdvancementGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.GlobalLootModifier;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.LootTableGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.ModRecipeGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.ParticleDescriptionGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.SoundDefinitionsGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.model.BlockModelGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.model.BlockStateGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.model.ItemModelGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagItem;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagPoiType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        DataGenerator.PackGenerator vanillaPack = generator.m_253147_(true);
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput pack = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(pack, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootTableGenerator.BlockLootTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(LootTableGenerator.EntityLootTables::new, LootContextParamSets.f_81415_))));
        TagBlock block = (TagBlock)vanillaPack.m_253108_(packOutput -> new TagBlock(packOutput, registries, helper));
        vanillaPack.m_253108_(packOutput -> new TagItem(packOutput, registries, block.m_274426_(), helper));
        vanillaPack.m_253108_(packOutput -> new TagPoiType(packOutput, registries, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeGenerator(generator));
        generator.addProvider(true, (DataProvider)new ForgeAdvancementProvider(pack, registries, helper, Collections.singletonList(new AdvancementGenerator())));
        generator.addProvider(event.includeServer(), (DataProvider)new GlobalLootModifier(pack));
        generator.addProvider(event.includeClient(), (DataProvider)new ParticleDescriptionGenerator(pack, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockModelGenerator(pack, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(pack, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(pack, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new SoundDefinitionsGenerator(pack, helper));
    }
}

