/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.compat.jei.category;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.mixin.MobBucketItemAccessor;
import com.github.ysbbbbbb.kaleidoscopecookery.recipe.StockpotRecipe;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeCategory
implements IRecipeCategory<StockpotRecipe> {
    public static final RecipeType<StockpotRecipe> TYPE = RecipeType.create((String)"kaleidoscope_cookery", (String)"stockpot", StockpotRecipe.class);
    private static final ResourceLocation BG = new ResourceLocation("kaleidoscope_cookery", "textures/gui/jei/stockpot.png");
    private static final MutableComponent TITLE = Component.m_237115_((String)"block.kaleidoscope_cookery.stockpot");
    private static final Map<ResourceLocation, Item> RECIPE_TO_BUCKET_MAP = Maps.newHashMap();
    public static final int WIDTH = 176;
    public static final int HEIGHT = 102;
    private final IDrawable bgDraw;
    private final IDrawable iconDraw;
    private final IDrawable slotDraw;
    private final IGuiHelper guiHelper;

    public StockpotRecipeCategory(IGuiHelper guiHelper) {
        this.bgDraw = guiHelper.createDrawable(BG, 0, 0, 176, 102);
        this.iconDraw = guiHelper.createDrawableItemLike((ItemLike)ModItems.STOCKPOT.get());
        this.slotDraw = guiHelper.getSlotDrawable();
        this.guiHelper = guiHelper;
    }

    public static List<StockpotRecipe> getRecipes() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return List.of();
        }
        HashMap entityTypeToBucketMap = Maps.newHashMap();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof MobBucketItemAccessor).forEach(item -> {
            MobBucketItemAccessor mobBucketItem = (MobBucketItemAccessor)item;
            entityTypeToBucketMap.put(mobBucketItem.kaleidoscope$GetFishType(), item);
        });
        ArrayList stockpotRecipes = Lists.newArrayList();
        stockpotRecipes.addAll(level.m_7465_().m_44013_(ModRecipes.STOCKPOT_RECIPE));
        stockpotRecipes.forEach(recipe -> {
            EntityType<?> entityType = recipe.getInputEntityType();
            if (entityType != null && entityTypeToBucketMap.containsKey(entityType)) {
                Item bucketItem = (Item)entityTypeToBucketMap.get(entityType);
                RECIPE_TO_BUCKET_MAP.put(recipe.m_6423_(), bucketItem);
            } else {
                Item bucket = recipe.getSoupBase().m_6859_();
                RECIPE_TO_BUCKET_MAP.put(recipe.m_6423_(), bucket);
            }
        });
        return stockpotRecipes;
    }

    public void draw(StockpotRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.bgDraw.draw(guiGraphics);
        this.guiHelper.createDrawableItemLike((ItemLike)Items.f_42399_).draw(guiGraphics, 133, 18);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StockpotRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> inputs = recipe.m_7527_();
        ItemStack output = recipe.getResult();
        for (int i = 0; i < inputs.size(); ++i) {
            int xOffset = i % 3 * 18 + 15;
            int yOffset = i / 3 * 18 + 25;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset).addIngredients((Ingredient)inputs.get(i))).setBackground(this.slotDraw, -1, -1);
        }
        Item bucket = RECIPE_TO_BUCKET_MAP.get(recipe.m_6423_());
        if (bucket != null) {
            builder.addSlot(RecipeIngredientRole.INPUT, 72, 61).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{bucket}));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 143, 60).addItemStack(output);
    }

    public RecipeType<StockpotRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 102;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.iconDraw;
    }
}

