/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.block.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagItem;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.recipe.PotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.util.IntRange;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;

public class PotBlockEntity
extends BlockEntity
implements Container {
    public static final IntRange INGREDIENT_TICK = IntRange.second(0, 30);
    public static final int PUT_INGREDIENT = 0;
    public static final int COOKING = 1;
    public static final int FINISHED = 2;
    private static final String SEED = "Seed";
    private static final String STATUS = "Status";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String STIR_FRY_COUNT = "StirFryCount";
    private static final String NEED_BOWL = "NeedBowl";
    private static final String RECIPE_ID = "RecipeId";
    private static final String RESULT_TICK = "ResultTick";
    private static final String RESULT_STACK = "ResultStack";
    private static final String BURNT_LEVEL = "BurntLevel";
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private ItemStack result = ItemStack.f_41583_;
    private int status = 0;
    private int currentTick = 0;
    @Nullable
    private ResourceLocation recipeId;
    @Nullable
    private IntRange getResultTick;
    private int stirFryCount = 0;
    private boolean needBowl = false;
    private int burntLevel = 0;
    private long seed;
    public StirFryAnimationData animationData = new StirFryAnimationData();

    public PotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlocks.POT_BE.get(), pPos, pBlockState);
        this.seed = System.currentTimeMillis();
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        RandomSource random = this.f_58857_.f_46441_;
        Optional value = this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_61145_((Property)BlockStateProperties.f_61443_);
        if (value.isEmpty() || !((Boolean)value.get()).booleanValue()) {
            return;
        }
        ++this.currentTick;
        if (this.currentTick % 5 == 0) {
            this.refresh();
        }
        if (this.currentTick % 20 == 0) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.5f + random.m_188501_() / 0.5f, 0.8f + random.m_188501_() / 0.5f);
        }
        if (this.status == 0) {
            Level level;
            if (INGREDIENT_TICK.after(this.currentTick)) {
                this.onPreparationTimeout(this.f_58857_);
            }
            if (this.currentTick % 10 == 0 && (level = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 5.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 5.0 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.getResultTick == null) {
            return;
        }
        if (this.status == 1 && this.currentTick > this.getResultTick.start()) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
            this.result = this.getResult(this.f_58857_);
            this.status = 2;
            this.m_6596_();
            if (this.f_58857_ != null) {
                BlockState state = this.f_58857_.m_8055_(this.f_58858_);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
            }
        }
        if (this.status == 2) {
            int time = this.currentTick - this.getResultTick.start();
            if (time < 400) {
                Level level;
                if (this.currentTick % 10 == 0 && (level = this.f_58857_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 2.0, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            } else {
                Level level;
                this.burntLevel = (time - 400) / 25;
                this.burntLevel = Mth.m_14045_((int)this.burntLevel, (int)0, (int)16);
                if (this.currentTick % 2 == 0 && (level = this.f_58857_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.burntLevel >= 2) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.25 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), this.burntLevel / 2, 0.0, 0.0, 0.0, 0.05);
                    }
                }
            }
            if (this.getResultTick.after(this.currentTick) && this.f_58857_ != null) {
                this.onFinishedTimeout(this.f_58857_);
            }
        }
    }

    private void onFinishedTimeout(Level level) {
        this.reset();
        RandomSource random = level.f_46441_;
        level.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
        Level level2 = this.f_58857_;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.25 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
            int count = 1 + random.m_188503_(3);
            Block.m_49840_((Level)level, (BlockPos)this.f_58858_, (ItemStack)new ItemStack((ItemLike)Items.f_42414_, count));
        }
    }

    private void onPreparationTimeout(Level level) {
        if (!this.m_7983_()) {
            this.startCooking(level);
            return;
        }
        this.reset();
        RandomSource random = level.f_46441_;
        level.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
        Level level2 = this.f_58857_;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
        }
    }

    public void onShovelHit(Level level, Player player, ItemStack shovel) {
        Level level2;
        if (!player.m_9236_().f_46443_) {
            this.seed = System.currentTimeMillis();
            this.refresh();
        }
        if ((level2 = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            RandomSource random = serverLevel.f_46441_;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
        }
        if (this.status == 0 && !this.m_7983_()) {
            this.startCooking(level);
        }
        if (this.status == 1) {
            ++this.stirFryCount;
        }
    }

    private void startCooking(Level level) {
        level.m_7465_().m_44015_(ModRecipes.POT_RECIPE, (Container)this, level).ifPresentOrElse(recipe -> {
            this.recipeId = recipe.m_6423_();
            this.needBowl = recipe.isNeedBowl();
            int time = recipe.getTime() / 20;
            this.getResultTick = IntRange.second(time, time + 40);
        }, () -> {
            this.recipeId = null;
            this.getResultTick = IntRange.second(10, 50);
        });
        this.status = 1;
        this.currentTick = 0;
        this.refresh();
    }

    private ItemStack getResult(Level level) {
        PotRecipe potRecipe;
        Optional recipe;
        Item suspiciousStirFry = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY);
        ItemStack result = suspiciousStirFry.m_7968_();
        if (this.recipeId != null && (recipe = level.m_7465_().m_220248_(ModRecipes.POT_RECIPE, (Container)this, level, this.recipeId)).isPresent() && this.stirFryCount >= (potRecipe = (PotRecipe)((Pair)recipe.get()).getSecond()).getStirFryCount()) {
            result = potRecipe.getResult().m_41777_();
        }
        if (result.m_150930_(suspiciousStirFry)) {
            this.needBowl = true;
        }
        return result;
    }

    public void takeOut(Player player) {
        if (this.status != 2) {
            return;
        }
        if (this.getResultTick == null) {
            return;
        }
        ItemStack finallyResult = this.getResult(this.f_58857_);
        int time = this.currentTick - this.getResultTick.start();
        if (time > 400) {
            finallyResult = new ItemStack((ItemLike)FoodBiteRegistry.getItem(FoodBiteRegistry.DARK_CUISINE));
        }
        if (this.needBowl) {
            if (player.m_21205_().m_150930_(Items.f_42399_)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)finallyResult);
                player.m_21205_().m_41774_(1);
                this.reset();
            } else {
                player.m_6469_(player.m_9236_().m_269111_().m_269387_(), 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MutableComponent component = Component.m_237115_((String)"tip.kaleidoscope_cookery.pot.need_bowl");
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)component));
                }
            }
        } else if (player.m_21205_().m_150930_((Item)ModItems.KITCHEN_SHOVEL.get())) {
            if (player.m_36341_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)finallyResult);
                this.reset();
            }
        } else {
            player.m_6469_(player.m_9236_().m_269111_().m_269387_(), 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MutableComponent component = Component.m_237115_((String)"tip.kaleidoscope_cookery.pot.need_kitchen_shovel");
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)component));
            }
        }
    }

    public void addIngredient(ItemStack itemStack, Player player) {
        int i;
        if (this.status != 0) {
            return;
        }
        if (itemStack.m_41619_()) {
            for (i = this.items.size() - 1; i >= 0; --i) {
                ItemStack stack = (ItemStack)this.items.get(i);
                if (stack.m_41619_()) continue;
                this.items.set(i, (Object)ItemStack.f_41583_);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                player.m_6469_(player.m_9236_().m_269111_().m_269387_(), 1.0f);
                return;
            }
        }
        if (!itemStack.m_41614_() && !itemStack.m_204117_(TagItem.POT_INGREDIENT)) {
            return;
        }
        for (i = 0; i < this.m_6643_(); ++i) {
            ItemStack item = this.m_8020_(i);
            if (!item.m_41619_()) continue;
            this.m_6836_(i, itemStack.m_255036_(1));
            itemStack.m_41774_(1);
            player.m_9236_().m_5594_(null, this.f_58858_, SoundEvents.f_12028_, SoundSource.BLOCKS, 1.0f, 0.5f);
            return;
        }
    }

    public void reset() {
        this.currentTick = 0;
        this.recipeId = null;
        this.getResultTick = null;
        this.result = ItemStack.f_41583_;
        this.stirFryCount = 0;
        this.needBowl = false;
        this.burntLevel = 0;
        this.items.clear();
        this.status = 0;
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)PotBlock.HAS_OIL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128356_(SEED, this.seed);
        tag.m_128405_(STATUS, this.status);
        tag.m_128405_(CURRENT_TICK, this.currentTick);
        tag.m_128405_(STIR_FRY_COUNT, this.stirFryCount);
        tag.m_128379_(NEED_BOWL, this.needBowl);
        tag.m_128405_(BURNT_LEVEL, this.burntLevel);
        if (this.recipeId != null) {
            tag.m_128359_(RECIPE_ID, this.recipeId.toString());
        }
        if (this.getResultTick != null) {
            tag.m_128365_(RESULT_TICK, (Tag)this.getResultTick.serialize());
        }
        tag.m_128365_(RESULT_STACK, (Tag)this.result.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.seed = tag.m_128454_(SEED);
        this.status = tag.m_128451_(STATUS);
        this.currentTick = tag.m_128451_(CURRENT_TICK);
        this.stirFryCount = tag.m_128451_(STIR_FRY_COUNT);
        this.needBowl = tag.m_128471_(NEED_BOWL);
        this.burntLevel = tag.m_128451_(BURNT_LEVEL);
        if (tag.m_128441_(RECIPE_ID)) {
            this.recipeId = new ResourceLocation(tag.m_128461_(RECIPE_ID));
        }
        if (tag.m_128441_(RESULT_TICK)) {
            this.getResultTick = IntRange.deserialize(tag.m_128469_(RESULT_TICK));
        }
        this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(RESULT_STACK));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return 0 <= index && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        if (0 <= pIndex && pIndex < this.items.size()) {
            this.items.set(pIndex, (Object)pStack);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public long getSeed() {
        return this.seed;
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public IntRange getGetResultTick() {
        return this.getResultTick;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public int getStirFryCount() {
        return this.stirFryCount;
    }

    public int getBurntLevel() {
        return this.burntLevel;
    }

    public boolean isNeedBowl() {
        return this.needBowl;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static class StirFryAnimationData {
        public long preSeed = -1L;
        public long timestamp = -1L;
        public float[] randomHeights = new float[0];
    }
}

