/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class FruitBasketBlockEntity
extends BlockEntity {
    public static final String ITEMS = "BasketItems";
    private final ItemStackHandler items = new ItemStackHandler(8);

    public FruitBasketBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlocks.FRUIT_BASKET_BE.get(), pPos, pBlockState);
    }

    public void putOn(ItemStack stack) {
        if (!stack.m_41720_().m_142095_()) {
            return;
        }
        ItemStack reminder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.items, (ItemStack)stack.m_41777_(), (boolean)false);
        if (stack.m_41613_() != reminder.m_41613_()) {
            stack.m_41774_(stack.m_41613_() - reminder.m_41613_());
            if (this.f_58857_ != null) {
                this.f_58857_.m_247517_(null, this.f_58858_, SoundEvents.f_12013_, SoundSource.BLOCKS);
            }
            this.refresh();
        }
    }

    public void takeOut(Player player) {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemStack extractItem = this.items.extractItem(i, this.items.getSlotLimit(i), false);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extractItem);
            if (this.f_58857_ != null) {
                this.f_58857_.m_247517_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS);
            }
            this.refresh();
            return;
        }
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS, (Tag)this.items.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.deserializeNBT(tag.m_128469_(ITEMS));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStackHandler getItems() {
        return this.items;
    }
}

