/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.KitchenShovelItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PotBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HAS_OIL = BooleanProperty.m_61465_((String)"has_oil");
    public static final BooleanProperty SHOW_OIL = BooleanProperty.m_61465_((String)"show_oil");
    public static final VoxelShape AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

    public PotBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(ModSoundType.POT).m_60955_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_OIL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHOW_OIL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> pServerType, BlockEntityType<E> pClientType, BlockEntityTicker<? super E> pTicker) {
        return pClientType == pServerType ? pTicker : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        if (pHand == InteractionHand.OFF_HAND) {
            return super.m_6227_(state, level, pos, player, pHand, pHit);
        }
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (!belowState.m_61138_((Property)BlockStateProperties.f_61443_) || !((Boolean)belowState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.sendBarMessage(player, Component.m_237115_((String)"tip.kaleidoscope_cookery.pot.need_lit_stove"));
            return InteractionResult.FAIL;
        }
        ItemStack itemInHand = player.m_21120_(pHand);
        RandomSource random = level.f_46441_;
        if (!((Boolean)state.m_61143_((Property)HAS_OIL)).booleanValue()) {
            if (itemInHand.m_204117_(TagMod.OIL)) {
                this.placeOil(state, level, pos, player, random);
                itemInHand.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (itemInHand.m_150930_((Item)ModItems.KITCHEN_SHOVEL.get()) && KitchenShovelItem.hasOil(itemInHand)) {
                this.placeOil(state, level, pos, player, random);
                KitchenShovelItem.setHasOil(itemInHand, false);
                return InteractionResult.SUCCESS;
            }
            this.sendBarMessage(player, Component.m_237115_((String)"tip.kaleidoscope_cookery.pot.need_oil"));
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PotBlockEntity) {
            PotBlockEntity pot = (PotBlockEntity)blockEntity;
            this.cooking(level, pos, player, pot, itemInHand, random);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, pHand, pHit);
    }

    private void sendBarMessage(Player player, MutableComponent message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    private void cooking(Level level, BlockPos pos, Player player, PotBlockEntity pot, ItemStack itemInHand, RandomSource random) {
        if (itemInHand.m_150930_((Item)ModItems.KITCHEN_SHOVEL.get())) {
            pot.onShovelHit(level, player, itemInHand);
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f + (random.m_188501_() - random.m_188501_()) * 0.8f);
            return;
        }
        if (pot.getStatus() == 2) {
            pot.takeOut(player);
            return;
        }
        pot.addIngredient(itemInHand, player);
    }

    private void placeOil(BlockState pState, Level level, BlockPos pos, Player player, RandomSource random) {
        level.m_46597_(pos, (BlockState)((BlockState)pState.m_61124_((Property)HAS_OIL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SHOW_OIL, (Comparable)Boolean.valueOf(true)));
        level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
        for (int i = 0; i < 10; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.25 + random.m_188500_() / 3.0, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.05, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PotBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.f_46443_) {
            return null;
        }
        if (!((Boolean)pState.m_61143_((Property)HAS_OIL)).booleanValue()) {
            return null;
        }
        return PotBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlocks.POT_BE.get(), (level, pos, state, pot) -> pot.tick());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_OIL, SHOW_OIL, f_54117_, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }
}

