/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.registries;

import io.github.tt432.kitchenkarrot.recipes.base.BaseRecipe;
import io.github.tt432.kitchenkarrot.recipes.recipe.AirCompressorRecipe;
import io.github.tt432.kitchenkarrot.recipes.recipe.BrewingBarrelRecipe;
import io.github.tt432.kitchenkarrot.recipes.recipe.CocktailRecipe;
import io.github.tt432.kitchenkarrot.recipes.recipe.PlateRecipe;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class RecipeTypes {
    private static final DeferredRegister<RecipeType<?>> TYPES = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"kitchenkarrot");
    public static final RegistryObject<RecipeType<CocktailRecipe>> COCKTAIL = RecipeTypes.register("cocktail");
    public static final RegistryObject<RecipeType<AirCompressorRecipe>> AIR_COMPRESSOR = RecipeTypes.register("air_compressing");
    public static final RegistryObject<RecipeType<BrewingBarrelRecipe>> BREWING_BARREL = RecipeTypes.register("brewing_barrel");
    public static final RegistryObject<RecipeType<PlateRecipe>> PLATE = RecipeTypes.register("plate");

    private static <TYPE extends BaseRecipe<TYPE>> RegistryObject<RecipeType<TYPE>> register(final String name) {
        return TYPES.register(name, () -> new RecipeType<TYPE>(){

            public String toString() {
                return new ResourceLocation("kitchenkarrot", name).toString();
            }
        });
    }

    public static void register(IEventBus bus) {
        TYPES.register(bus);
    }
}

