/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.registries;

import io.github.tt432.kitchenkarrot.block.AirCompressorBlock;
import io.github.tt432.kitchenkarrot.block.BrewingBarrelBlock;
import io.github.tt432.kitchenkarrot.block.CoasterBlock;
import io.github.tt432.kitchenkarrot.block.PlateBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"kitchenkarrot");
    public static final RegistryObject<Block> AIR_COMPRESSOR = BLOCKS.register("air_compressor", AirCompressorBlock::new);
    public static final RegistryObject<Block> BREWING_BARREL = BLOCKS.register("brewing_barrel", () -> new BrewingBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60955_()));
    public static final RegistryObject<Block> ROCK_SALT = ModBlocks.salt("rock_salt");
    public static final RegistryObject<Block> SEA_SALT = ModBlocks.salt("sea_salt");
    public static final RegistryObject<Block> FINE_SALT = ModBlocks.salt("fine_salt");
    public static final RegistryObject<Block> SUNFLOWER_OIL = ModBlocks.oil("sunflower_oil");
    public static final RegistryObject<Block> ACORN_OIL = ModBlocks.oil("acorn_oil");
    public static final RegistryObject<Block> CHORUS_OIL = ModBlocks.oil("chorus_oil");
    public static final RegistryObject<Block> COASTER = BLOCKS.register("coaster", () -> new CoasterBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 0.5f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> PLATE = BLOCKS.register("plate", () -> new PlateBlock(BlockBehaviour.Properties.m_284310_().m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_56744_)));
    protected static final VoxelShape OIL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0));
    protected static final VoxelShape SALT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0));

    private static RegistryObject<Block> oil(String name) {
        return BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(1.0f, 1.0f)){

            @NotNull
            public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
                return OIL;
            }
        });
    }

    private static RegistryObject<Block> salt(String name) {
        return BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(1.0f, 1.0f)){

            @NotNull
            public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
                return SALT;
            }
        });
    }
}

