/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.dependencies.jei.category;

import io.github.tt432.kitchenkarrot.dependencies.jei.JeiPlugin;
import io.github.tt432.kitchenkarrot.dependencies.jei.category.BaseRecipeCategory;
import io.github.tt432.kitchenkarrot.recipes.recipe.CocktailRecipe;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CocktailRecipeCategory
extends BaseRecipeCategory<CocktailRecipe> {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("kitchenkarrot", "textures/gui/jei.png");

    public CocktailRecipeCategory(IGuiHelper helper) {
        super(JeiPlugin.COCKTAIL, helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.SHAKER.get())), (IDrawable)helper.createDrawable(BACKGROUND, 0, 0, 119, 71));
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, CocktailRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> ingredients = recipe.getContent().getRecipe();
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 15).addIngredients(ingredients.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 66, 15).addIngredients(ingredients.get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 88, 15).addIngredients(ingredients.get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 39).addIngredients(ingredients.get(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 78, 39).addIngredients(ingredients.get(4));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 15, 19).addItemStack(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
    }

    public void draw(CocktailRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.drawShakeTime(recipe, guiGraphics);
    }

    private void drawShakeTime(CocktailRecipe recipe, GuiGraphics guiGraphics) {
        int timeInTicks = recipe.getContent().getCraftingTime();
        if (timeInTicks > 0) {
            int timeInSeconds = timeInTicks / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{timeInSeconds});
            Font font = Minecraft.m_91087_().f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(font, (Component)timeString, this.getWidth() - stringWidth - 7, 57, -13684945, false);
        }
    }
}

