/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.datagen.provider;

import com.google.common.collect.ImmutableSet;
import io.github.tt432.kitchenkarrot.Kitchenkarrot;
import io.github.tt432.kitchenkarrot.registries.ModBlocks;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModItemModelProvider
extends ItemModelProvider {
    private final Set<Item> skipSet = new HashSet<Item>();
    private static final ImmutableSet<RegistryObject<Item>> IGNORES = ImmutableSet.of(ModItems.KNIFE, ModItems.COCKTAIL);

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "kitchenkarrot", existingFileHelper);
    }

    protected void registerModels() {
        this.initSkip();
        for (RegistryObject entry : ModItems.ITEMS.getEntries().stream().filter(e -> !(e.get() instanceof BlockItem)).toList()) {
            if (IGNORES.contains((Object)entry)) continue;
            this.basicItem((Item)entry.get());
        }
        this.tool(ModItems.KNIFE);
        this.genBlockGenerated(ModBlocks.ACORN_OIL);
        this.genBlockGenerated(ModBlocks.CHORUS_OIL);
        this.genBlockGenerated(ModBlocks.SUNFLOWER_OIL);
        this.genBlockGenerated(ModBlocks.FINE_SALT);
        this.genBlockGenerated(ModBlocks.ROCK_SALT);
        this.genBlockGenerated(ModBlocks.SEA_SALT);
        ModBlocks.BLOCKS.getEntries().stream().filter(holder -> this.isSkip(((Block)holder.get()).m_5456_())).forEach(this::genBlockItemModel);
    }

    protected Boolean isSkip(Item item) {
        return !this.skipSet.contains(item);
    }

    protected void skip(Item item) {
        this.skipSet.add(item);
    }

    protected void initSkip() {
        this.skip(((Block)ModBlocks.PLATE.get()).m_5456_());
    }

    @NotNull
    private ItemModelBuilder tool(@NotNull RegistryObject<Item> item) {
        this.skip((Item)item.get());
        ResourceLocation rl = item.getId();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(rl.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", new ResourceLocation("kitchenkarrot", "item/" + rl.m_135815_()));
    }

    protected ItemModelBuilder genBlockGenerated(RegistryObject<Block> block) {
        this.skip(((Block)block.get()).m_5456_());
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("kitchenkarrot", "item/" + block.getId().m_135815_()));
    }

    private ItemModelBuilder genBlockItemModel(RegistryObject<Block> block) {
        String id = block.getId().m_135815_();
        return (ItemModelBuilder)this.withExistingParent(id, Kitchenkarrot.getModRL("block/" + id));
    }
}

