/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.blockentity.sync;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;

public abstract class SyncData<V>
implements NonNullSupplier<V> {
    private V value;
    private boolean changed;
    private final String name;
    public final boolean needSave;

    public SyncData(String name, V defaultValue, boolean needSave) {
        this.value = defaultValue;
        this.name = name;
        this.needSave = needSave;
    }

    protected abstract CompoundTag toTag();

    protected abstract V fromTag(CompoundTag var1);

    @NotNull
    public V get() {
        return this.value;
    }

    public void set(V value) {
        this.value = value;
        this.onChanged();
    }

    public void save(CompoundTag tag, boolean force) {
        if (this.changed || force) {
            tag.m_128365_(this.name, (Tag)this.toTag());
            this.changed = false;
        }
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_(this.name)) {
            this.value = this.fromTag(tag.m_128469_(this.name));
        }
    }

    protected void onChanged() {
        this.changed = true;
    }
}

