/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.blockentity;

import io.github.tt432.kitchenkarrot.block.BrewingBarrelBlock;
import io.github.tt432.kitchenkarrot.blockentity.MenuBlockEntity;
import io.github.tt432.kitchenkarrot.blockentity.sync.BoolSyncData;
import io.github.tt432.kitchenkarrot.blockentity.sync.FluidTankSyncData;
import io.github.tt432.kitchenkarrot.blockentity.sync.IntSyncData;
import io.github.tt432.kitchenkarrot.blockentity.sync.StringSyncData;
import io.github.tt432.kitchenkarrot.blockentity.sync.SyncDataManager;
import io.github.tt432.kitchenkarrot.capability.KKItemStackHandler;
import io.github.tt432.kitchenkarrot.menu.BrewingBarrelMenu;
import io.github.tt432.kitchenkarrot.recipes.recipe.BrewingBarrelRecipe;
import io.github.tt432.kitchenkarrot.registries.ModBlockEntities;
import io.github.tt432.kitchenkarrot.registries.RecipeTypes;
import io.github.tt432.kitchenkarrot.util.ItemHandlerUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingBarrelBlockEntity
extends MenuBlockEntity {
    public static final int FLUID_CONSUMPTION = 500;
    public static final int FLUID_CAPACITY = 4000;
    FluidTankSyncData tank;
    public KKItemStackHandler input = new KKItemStackHandler(this, 6);
    private KKItemStackHandler result = new KKItemStackHandler(this, 1);
    private IntSyncData progress;
    private IntSyncData maxProgress;
    private StringSyncData recipe;
    private BrewingBarrelRecipe currentRecipe;
    private BoolSyncData started;

    public BrewingBarrelBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.BREWING_BARREL.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void syncDataInit(SyncDataManager manager) {
        this.tank = new FluidTankSyncData("fluid", 4000, f -> f.getFluid() == Fluids.f_76193_, true);
        manager.add(this.tank);
        this.progress = new IntSyncData("progress", 0, true);
        manager.add(this.progress);
        this.maxProgress = new IntSyncData("maxProgress", 0, true);
        manager.add(this.maxProgress);
        this.recipe = new StringSyncData("recipe", "", true);
        manager.add(this.recipe);
        this.started = new BoolSyncData("started", false, true);
        manager.add(this.started);
    }

    public BrewingBarrelRecipe getRecipe() {
        return this.currentRecipe == null && !this.recipe.isEmpty() ? (this.currentRecipe = (BrewingBarrelRecipe)this.f_58857_.m_7465_().m_44043_(new ResourceLocation((String)this.recipe.get())).get()) : this.currentRecipe;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            Optional<BrewingBarrelRecipe> recipe = this.findRecipe();
            if (recipe.isPresent() && this.hasEnoughWater(recipe.get())) {
                if (this.isStarted()) {
                    if (this.isRecipeSame() && this.progress.plus(1, this.getMaxProgress()) == this.getMaxProgress().intValue()) {
                        this.finishBrewing();
                    }
                } else {
                    this.start();
                }
            } else if (this.isStarted()) {
                this.endProgress();
            }
        }
    }

    public Optional<BrewingBarrelRecipe> findRecipe() {
        List<ItemStack> inputList = ItemHandlerUtils.toList(new IItemHandler[]{this.input});
        return this.f_58857_.m_7465_().m_44013_((RecipeType)RecipeTypes.BREWING_BARREL.get()).stream().filter(r -> r.matches(inputList)).findFirst();
    }

    private void finishBrewing() {
        ItemStack resultStack = this.result.getStackInSlot(0);
        if (resultStack.m_41619_() || resultStack.m_150930_(this.getRecipe().m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_()) && resultStack.m_41613_() < resultStack.m_41741_()) {
            this.result.insertItem(0, this.getRecipe().m_8043_((RegistryAccess)RegistryAccess.f_243945_), false);
            for (int i = 0; i < this.input.getSlots(); ++i) {
                Item item = this.input.getStackInSlot(i).m_41720_();
                if (item.m_41470_()) {
                    Direction direction = ((Direction)this.m_58900_().m_61143_((Property)BrewingBarrelBlock.FACING)).m_122424_();
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5 + (double)direction.m_122429_() * 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5 + (double)direction.m_122431_() * 0.5, new ItemStack((ItemLike)item.m_41469_()), (double)direction.m_122429_() * 0.2, 0.0, (double)direction.m_122431_() * 0.2));
                }
                this.input.extractItem(i, 1, false);
            }
            ((FluidTankSyncData.SyncDataFluidTank)((Object)this.tank.get())).drain(this.getRecipe().getWaterConsumption(), IFluidHandler.FluidAction.EXECUTE);
            this.endProgress();
        }
    }

    public boolean resultEmpty() {
        return this.result.getStackInSlot(0).m_41619_();
    }

    public boolean hasEnoughWater(BrewingBarrelRecipe recipe) {
        return ((FluidTankSyncData.SyncDataFluidTank)((Object)this.tank.get())).getFluidAmount() >= recipe.getWaterConsumption();
    }

    public boolean isRecipeSame() {
        return this.getRecipe() != null && this.getRecipe().matches(ItemHandlerUtils.toList(new IItemHandler[]{this.input}));
    }

    public boolean isStarted() {
        return (Boolean)this.started.get();
    }

    void endProgress() {
        this.started.set(false);
        this.setRecipe(null);
        this.resetProgress();
    }

    void setRecipe(BrewingBarrelRecipe recipe) {
        this.currentRecipe = recipe;
        if (recipe != null) {
            this.recipe.set(recipe.m_6423_().toString());
        } else {
            this.recipe.set("");
        }
    }

    void resetProgress() {
        if (this.isStarted()) {
            this.progress.set(0);
            this.maxProgress.set(this.currentRecipe.getCraftingTime());
        } else {
            this.progress.set(0);
            this.maxProgress.set(0);
        }
    }

    public void start() {
        List<ItemStack> inputList = ItemHandlerUtils.toList(new IItemHandler[]{this.input});
        this.f_58857_.m_7465_().m_44013_((RecipeType)RecipeTypes.BREWING_BARREL.get()).stream().filter(r -> r.matches(inputList)).forEach(r -> this.setRecipe((BrewingBarrelRecipe)r));
        this.started.set(true);
        this.resetProgress();
    }

    @Override
    public List<ItemStack> drops() {
        return ItemHandlerUtils.toList(new IItemHandler[]{this.input, this.result});
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new BrewingBarrelMenu(pContainerId, pInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> (IFluidHandler)this.tank.get()));
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return side == null ? LazyOptional.empty() : ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> this.result;
                case Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> this.input;
            }));
        }
        return LazyOptional.empty();
    }

    public Integer getMaxProgress() {
        return (Integer)this.maxProgress.get();
    }

    public Integer getProgress() {
        return (Integer)this.progress.get();
    }

    public IItemHandler result() {
        return this.result;
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("input", (Tag)this.input.serializeNBT());
        pTag.m_128365_("result", (Tag)this.result.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (!this.isSyncTag(pTag)) {
            this.input.deserializeNBT(pTag.m_128469_("input"));
            this.result.deserializeNBT(pTag.m_128469_("result"));
        }
    }

    public void playSound(SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BrewingBarrelBlock.FACING)).m_122436_();
        double d0 = (double)this.m_58899_().m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.m_58899_().m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.m_58899_().m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

