/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.item.custom;

import net.hecco.bountifulfares.util.BFBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class GrassSeedsItem
extends Item {
    public GrassSeedsItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (world.getBlockState(pos).is(BFBlockTags.GRASS_SEEDS_PLANTABLE_ON) && !world.getBlockState(pos.above()).isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN)) {
            world.setBlockAndUpdate(pos, Blocks.GRASS_BLOCK.defaultBlockState());
            world.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            for (int i = 0; i < 16; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() - 0.2 + (double)world.random.nextFloat() * 1.4, (double)pos.getY() + (double)world.random.nextFloat() * 0.5 + 0.8, (double)pos.getZ() - 0.2 + (double)world.random.nextFloat() * 1.4, ((double)world.random.nextFloat() - 0.5) / 8.0, ((double)world.random.nextFloat() - 0.5) / 8.0, ((double)world.random.nextFloat() - 0.5) / 8.0);
            }
            if (context.getPlayer() != null && !context.getPlayer().isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)true);
        }
        return super.useOn(context);
    }
}

