/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.item.custom;

import net.hecco.bountifulfares.entity.FlourProjectileEntity;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FlourItem
extends Item {
    public FlourItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        world.playSound(null, user.getX(), user.getY(), user.getZ(), BFSounds.FLOUR_THROW, SoundSource.NEUTRAL, 0.6f, 0.9f + world.random.nextFloat() / 4.0f);
        if (!world.isClientSide) {
            FlourProjectileEntity flourProjectileEntity = new FlourProjectileEntity((LivingEntity)user, world);
            flourProjectileEntity.setItem(itemStack);
            flourProjectileEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 0.35f, 7.5f);
            world.addFreshEntity((Entity)flourProjectileEntity);
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!user.isCreative()) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }
}

