/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.item.custom;

import java.util.List;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.entity.CeramicDishBlockEntity;
import net.hecco.bountifulfares.block.entity.DyeableCeramicBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ArtisanBrushItem
extends Item
implements DyeableLeatherItem {
    public int DefColor = 0xFFFFFF;

    public ArtisanBrushItem(Item.Properties settings) {
        super(settings);
    }

    public int getColor(ItemStack stack) {
        CompoundTag nbtCompound = stack.getTagElement("display");
        if (nbtCompound != null && nbtCompound.contains("color", 99)) {
            return nbtCompound.getInt("color");
        }
        return this.DefColor;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockState current = world.getBlockState(pos);
        int oldColor = DyeableCeramicBlockEntity.getColor((BlockGetter)world, pos);
        if (BFBlocks.CERAMIC_TO_CHECKERED_CERAMIC.containsKey(current.getBlock()) && DyeableCeramicBlockEntity.getColor((BlockGetter)world, pos) != 0xFFFFFF && this.getColor(context.getItemInHand()) == DyeableCeramicBlockEntity.getColor((BlockGetter)world, pos)) {
            world.setBlockAndUpdate(pos, BFBlocks.CERAMIC_TO_CHECKERED_CERAMIC.get(current.getBlock()).withPropertiesOf(current));
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DyeableCeramicBlockEntity) {
                DyeableCeramicBlockEntity ceramicTilesBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                ceramicTilesBlockEntity.color = oldColor;
                ceramicTilesBlockEntity.setChanged();
                return InteractionResult.SUCCESS;
            }
        }
        if ((world.getBlockEntity(pos) instanceof DyeableCeramicBlockEntity || world.getBlockEntity(pos) instanceof CeramicDishBlockEntity) && (DyeableCeramicBlockEntity.getColor((BlockGetter)world, pos) != 0xFFFFFF || CeramicDishBlockEntity.getColor((BlockGetter)world, pos) != 0xFFFFFF)) {
            if (world.getBlockEntity(pos) instanceof DyeableCeramicBlockEntity && this.getColor(context.getItemInHand()) != DyeableCeramicBlockEntity.getColor((BlockGetter)world, pos)) {
                this.setColor(context.getItemInHand(), DyeableCeramicBlockEntity.getColor((BlockGetter)world, pos));
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (world.getBlockEntity(pos) instanceof CeramicDishBlockEntity && this.getColor(context.getItemInHand()) != CeramicDishBlockEntity.getColor((BlockGetter)world, pos)) {
                this.setColor(context.getItemInHand(), CeramicDishBlockEntity.getColor((BlockGetter)world, pos));
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulfares.dyeable").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, world, tooltip, context);
    }
}

