/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.entity;

import net.hecco.bountifulfares.entity.BFEntities;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.particle.BFParticles;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class FlourProjectileEntity
extends ThrowableItemProjectile {
    public FlourProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public FlourProjectileEntity(LivingEntity livingEntity, Level world) {
        super(BFEntities.THROWN_FLOUR_PROJECTILE, livingEntity, world);
    }

    public FlourProjectileEntity(Level world, double x, double y, double z) {
        super(BFEntities.THROWN_FLOUR_PROJECTILE, x, y, z, world);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected Item getDefaultItem() {
        return BFItems.FLOUR;
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        Level world = this.level();
        if (!world.isClientSide()) {
            world.broadcastEntityEvent((Entity)this, (byte)3);
        }
        this.level().playSound(null, this.blockPosition(), BFSounds.FLOUR_LAND, SoundSource.BLOCKS, 1.0f, 0.9f + world.random.nextFloat() / 4.0f);
        if (world.isClientSide()) {
            return;
        }
        if (!this.level().isClientSide && !this.isRemoved()) {
            this.discard();
        }
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            int x;
            for (x = 0; x < 16; ++x) {
                this.level().addParticle((ParticleOptions)BFParticles.FLOUR_CLOUD_PARTICLE, this.getX() + (double)this.level().random.nextFloat(), this.getY() + (double)this.level().random.nextFloat(), this.getZ() + (double)this.level().random.nextFloat(), this.level().random.nextGaussian() / 16.0 + this.getDeltaMovement().x(), (double)(this.level().random.nextFloat() / 8.0f), this.level().random.nextGaussian() / 16.0 + this.getDeltaMovement().z());
            }
            for (x = 0; x < 16; ++x) {
                this.level().addAlwaysVisibleParticle((ParticleOptions)BFParticles.FLOUR_CLOUD_PARTICLE, this.getX() + (double)this.level().random.nextFloat(), this.getY() + (double)this.level().random.nextFloat(), this.getZ() + (double)this.level().random.nextFloat(), this.level().random.nextGaussian() / 16.0 + this.getDeltaMovement().x(), (double)(this.level().random.nextFloat() / 8.0f), this.level().random.nextGaussian() / 16.0 + this.getDeltaMovement().z());
            }
        }
    }
}

