/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.effect;

import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;

public class GorgingEffect
extends MobEffect {
    protected GorgingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void addAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            ((Player)entity).getFoodData().setFoodLevel(20);
        }
        super.addAttributeModifiers(entity, attributes, amplifier);
    }

    public void applyEffectTick(LivingEntity entity, int amplifier) {
        super.applyEffectTick(entity, amplifier);
        if (entity instanceof Player) {
            ((Player)entity).getFoodData().setExhaustion(0.0f);
        }
    }

    public void removeAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            ((Player)entity).getFoodData().setFoodLevel(1 + RandomSource.create().nextIntBetweenInclusive(0, 5));
        }
        super.removeAttributeModifiers(entity, attributes, amplifier);
    }

    public boolean isDurationEffectTick(int duration, int amplifier) {
        return true;
    }
}

