/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.hecco.bountifulfares.recipe.MillingRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MillingRecipeBuilder
implements RecipeBuilder {
    public final String detailedId;
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();

    public MillingRecipeBuilder(ItemLike ingredient, ItemLike output, int count, String detailedId) {
        this.detailedId = detailedId;
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        this.result = output.asItem();
        this.count = count;
    }

    public RecipeBuilder unlockedBy(String name, CriterionTriggerInstance conditions) {
        this.advancement.addCriterion(name, conditions);
        return this;
    }

    public RecipeBuilder group(@Nullable String group) {
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(Consumer<FinishedRecipe> exporter, ResourceLocation recipeId) {
        this.advancement.parent(new ResourceLocation("recipes/root")).addCriterion("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId));
        exporter.accept(new JsonBuilder(this.detailedId, recipeId, this.result, this.count, this.ingredient, this.advancement, new ResourceLocation(recipeId.getNamespace(), "recipes/" + recipeId.getPath())));
    }

    public static class JsonBuilder
    implements FinishedRecipe {
        public final String detailedId;
        private final ResourceLocation id;
        private final Item result;
        private final Ingredient ingredient;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public JsonBuilder(String detailedId, ResourceLocation id, Item result, int count, Ingredient ingredient, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.detailedId = detailedId;
            this.id = id;
            this.result = result;
            this.ingredient = ingredient;
            this.count = count;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void serializeRecipeData(JsonObject json) {
            JsonArray jsonarray = new JsonArray();
            jsonarray.add(this.ingredient.toJson());
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            json.add("output", (JsonElement)jsonobject);
        }

        public ResourceLocation getId() {
            if (this.detailedId != null) {
                return new ResourceLocation("bountifulfares", BuiltInRegistries.ITEM.getKey((Object)this.result).getPath() + "_from_milling_" + this.detailedId);
            }
            return new ResourceLocation("bountifulfares", BuiltInRegistries.ITEM.getKey((Object)this.result).getPath() + "_from_milling");
        }

        public RecipeSerializer<?> getType() {
            return MillingRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return this.advancement.serializeToJson();
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return this.advancementId;
        }
    }
}

