/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.datagen.custom;

import java.util.Optional;
import net.hecco.bountifulfares.block.custom.PicketsBlock;
import net.hecco.bountifulfares.trellis.TrellisUtil;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BFTemplateModels {
    public static final ModelTemplate TEMPLATE_PICKETS = new ModelTemplate(Optional.of(new ResourceLocation("bountifulfares", "template_pickets").withPrefix("block/")), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ModelTemplate TEMPLATE_TRELLIS = new ModelTemplate(Optional.of(new ResourceLocation("bountifulfares", "template_trellis").withPrefix("block/")), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ModelTemplate TEMPLATE_TRELLIS_0 = new ModelTemplate(Optional.of(new ResourceLocation("bountifulfares", "template_planted_trellis_0").withPrefix("block/")), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.CROP});
    public static final ModelTemplate TEMPLATE_TRELLIS_1 = new ModelTemplate(Optional.of(new ResourceLocation("bountifulfares", "template_planted_trellis").withPrefix("block/")), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.CROP, TextureSlot.FRONT});
    public static final ModelTemplate TEMPLATE_TRELLIS_UPSIDE_DOWN = new ModelTemplate(Optional.of(new ResourceLocation("bountifulfares", "template_planted_trellis_upside_down").withPrefix("block/")), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.CROP, TextureSlot.FRONT});

    public static void registerPicketsModels(BlockModelGenerators blockStateModelGenerator, Block picket) {
        ResourceLocation modelID = TEMPLATE_PICKETS.create(picket, TextureMapping.defaultTexture((Block)picket), blockStateModelGenerator.modelOutput);
        blockStateModelGenerator.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)picket).with((Condition)Condition.condition().term((Property)PicketsBlock.NORTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID)).with((Condition)Condition.condition().term((Property)PicketsBlock.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.EAST, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID)).with((Condition)Condition.condition().term((Property)PicketsBlock.EAST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)PicketsBlock.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.EAST, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)PicketsBlock.SOUTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).with((Condition)Condition.condition().term((Property)PicketsBlock.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.EAST, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).with((Condition)Condition.condition().term((Property)PicketsBlock.WEST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).with((Condition)Condition.condition().term((Property)PicketsBlock.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.EAST, (Comparable)Boolean.valueOf(false)).term((Property)PicketsBlock.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)));
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)picket.asItem()), TextureMapping.layer0((ResourceLocation)BFTemplateModels.getItemId(picket)), blockStateModelGenerator.modelOutput);
    }

    public static void registerTrellis(BlockModelGenerators blockStateModelGenerator, TrellisVariant trellis) {
        ResourceLocation modelID = TEMPLATE_TRELLIS.create(TrellisUtil.getTrellisFromVariant(trellis), TextureMapping.defaultTexture((Block)TrellisUtil.getTrellisFromVariant(trellis)), blockStateModelGenerator.modelOutput);
        blockStateModelGenerator.delegateItemModel(TrellisUtil.getTrellisFromVariant(trellis), modelID);
        blockStateModelGenerator.skipAutoItemBlock(TrellisUtil.getTrellisFromVariant(trellis));
        blockStateModelGenerator.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)TrellisUtil.getTrellisFromVariant(trellis)).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)modelID).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270))));
    }

    public static void registerCropTrellis(BlockModelGenerators blockStateModelGenerator, Block trellis, String trellisId, String vinesId, String foliageId, String modId) {
        ResourceLocation modelID1 = TEMPLATE_TRELLIS_0.create(trellis, TextureMapping.defaultTexture((Block)trellis).put(TextureSlot.TEXTURE, new ResourceLocation(modId, "block/" + trellisId)).put(TextureSlot.CROP, new ResourceLocation("bountifulfares", "block/" + vinesId + "_0")), blockStateModelGenerator.modelOutput);
        ResourceLocation modelID2 = TEMPLATE_TRELLIS_1.createWithSuffix(trellis, "_1", TextureMapping.defaultTexture((Block)trellis).put(TextureSlot.TEXTURE, new ResourceLocation(modId, "block/" + trellisId)).put(TextureSlot.CROP, new ResourceLocation("bountifulfares", "block/" + vinesId + "_1")).put(TextureSlot.FRONT, new ResourceLocation("bountifulfares", "block/" + foliageId + "_1")), blockStateModelGenerator.modelOutput);
        ResourceLocation modelID3 = TEMPLATE_TRELLIS_1.createWithSuffix(trellis, "_2", TextureMapping.defaultTexture((Block)trellis).put(TextureSlot.TEXTURE, new ResourceLocation(modId, "block/" + trellisId)).put(TextureSlot.CROP, new ResourceLocation("bountifulfares", "block/" + vinesId + "_1")).put(TextureSlot.FRONT, new ResourceLocation("bountifulfares", "block/" + foliageId + "_2")), blockStateModelGenerator.modelOutput);
        ResourceLocation modelID4 = TEMPLATE_TRELLIS_1.createWithSuffix(trellis, "_3", TextureMapping.defaultTexture((Block)trellis).put(TextureSlot.TEXTURE, new ResourceLocation(modId, "block/" + trellisId)).put(TextureSlot.CROP, new ResourceLocation("bountifulfares", "block/" + vinesId + "_1")).put(TextureSlot.FRONT, new ResourceLocation("bountifulfares", "block/" + foliageId + "_3")), blockStateModelGenerator.modelOutput);
        blockStateModelGenerator.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)trellis).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270))).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.AGE_3).select((Comparable)Integer.valueOf(0), Variant.variant().with(VariantProperties.MODEL, (Object)modelID1)).select((Comparable)Integer.valueOf(1), Variant.variant().with(VariantProperties.MODEL, (Object)modelID2)).select((Comparable)Integer.valueOf(2), Variant.variant().with(VariantProperties.MODEL, (Object)modelID3)).select((Comparable)Integer.valueOf(3), Variant.variant().with(VariantProperties.MODEL, (Object)modelID4))));
    }

    public static void registerDecorTrellis(BlockModelGenerators blockStateModelGenerator, Block trellis, String trellisId, String vinesId, String foliageId, String modId) {
        ResourceLocation modelID4 = TEMPLATE_TRELLIS_1.create(trellis, TextureMapping.defaultTexture((Block)trellis).put(TextureSlot.TEXTURE, new ResourceLocation(modId, "block/" + trellisId)).put(TextureSlot.CROP, new ResourceLocation("bountifulfares", "block/" + vinesId)).put(TextureSlot.FRONT, new ResourceLocation("bountifulfares", "block/" + foliageId)), blockStateModelGenerator.modelOutput);
        blockStateModelGenerator.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)trellis).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270))));
    }

    public static void registerUpsideDownDecorTrellis(BlockModelGenerators blockStateModelGenerator, Block trellis, String trellisId, String vinesId, String foliageId, String modId) {
        ResourceLocation modelID4 = TEMPLATE_TRELLIS_UPSIDE_DOWN.create(trellis, TextureMapping.defaultTexture((Block)trellis).put(TextureSlot.TEXTURE, new ResourceLocation(modId, "block/" + trellisId)).put(TextureSlot.CROP, new ResourceLocation("bountifulfares", "block/" + vinesId)).put(TextureSlot.FRONT, new ResourceLocation("bountifulfares", "block/" + foliageId)), blockStateModelGenerator.modelOutput);
        blockStateModelGenerator.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)trellis).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)modelID4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270))));
    }

    public static ResourceLocation getItemId(Block block) {
        ResourceLocation identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
        return identifier.withPrefix("item/");
    }
}

