/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.config;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.chat.Component;

@Environment(value=EnvType.CLIENT)
public abstract class Entry<T> {
    private final String text;
    private final String[] tooltip;
    private final Supplier<T> current;
    private final Consumer<T> saver;
    private final T defaultValue;
    private final T min;
    private final T max;

    public static Entry<Boolean> booleanEntry(String name, Supplier<Boolean> current, Consumer<Boolean> saver, Boolean defaultValue) {
        return new Entry<Boolean>(name, current, saver, defaultValue, new String[0]){

            @Override
            TooltipListEntry<Boolean> build(ConfigEntryBuilder builder) {
                return ((BooleanToggleBuilder)builder.startBooleanToggle((Component)Component.translatable((String)this.getText()), ((Boolean)this.getCurrent().get()).booleanValue()).setSaveConsumer(this.getSaver()).setDefaultValue((Object)((Boolean)this.getDefaultValue()))).build();
            }
        };
    }

    public static Entry<Boolean> booleanEntry(String name, Supplier<Boolean> current, Consumer<Boolean> saver, Boolean defaultValue, String ... tooltip) {
        return new Entry<Boolean>(name, current, saver, defaultValue, tooltip){

            @Override
            TooltipListEntry<Boolean> build(ConfigEntryBuilder builder) {
                return ((BooleanToggleBuilder)builder.startBooleanToggle((Component)Component.translatable((String)this.getText()), ((Boolean)this.getCurrent().get()).booleanValue()).setSaveConsumer(this.getSaver()).setTooltip((Component[])Arrays.stream(this.getTooltip()).map(Component::translatable).toArray(Component[]::new)).setDefaultValue((Object)((Boolean)this.getDefaultValue()))).build();
            }
        };
    }

    public static Entry<Double> doubleEntry(String name, Supplier<Double> current, Consumer<Double> saver, Double defaultValue, Double min, Double max, String ... tooltip) {
        return new Entry<Double>(name, current, saver, defaultValue, min, max, tooltip){

            @Override
            TooltipListEntry<Double> build(ConfigEntryBuilder builder) {
                return ((DoubleFieldBuilder)((DoubleFieldBuilder)((DoubleFieldBuilder)builder.startDoubleField((Component)Component.translatable((String)this.getText()), ((Double)this.getCurrent().get()).doubleValue()).setSaveConsumer(this.getSaver()).setTooltip((Component[])Arrays.stream(this.getTooltip()).map(Component::literal).toArray(Component[]::new)).setDefaultValue((Object)((Double)this.getDefaultValue()))).setMin((Object)((Double)this.getMin()))).setMax((Object)((Double)this.getMax()))).build();
            }
        };
    }

    public static Entry<Integer> integerEntry(String name, Supplier<Integer> current, Consumer<Integer> saver, Integer defaultValue, Integer min, Integer max, String ... tooltip) {
        return new Entry<Integer>(name, current, saver, defaultValue, min, max, tooltip){

            @Override
            TooltipListEntry<Integer> build(ConfigEntryBuilder builder) {
                return ((IntFieldBuilder)((IntFieldBuilder)((IntFieldBuilder)builder.startIntField((Component)Component.translatable((String)this.getText()), ((Integer)this.getCurrent().get()).intValue()).setSaveConsumer(this.getSaver()).setTooltip((Component[])Arrays.stream(this.getTooltip()).map(Component::literal).toArray(Component[]::new)).setDefaultValue((Object)((Integer)this.getDefaultValue()))).setMin((Object)((Integer)this.getMin()))).setMax((Object)((Integer)this.getMax()))).build();
            }
        };
    }

    public static Entry<String> stringEntry(String name, Supplier<String> current, Consumer<String> saver, String defaultValue, String ... tooltip) {
        return new Entry<String>(name, current, saver, defaultValue, tooltip){

            @Override
            TooltipListEntry<String> build(ConfigEntryBuilder builder) {
                return builder.startStrField((Component)Component.literal((String)this.getText()), (String)this.getCurrent().get()).setSaveConsumer(this.getSaver()).setTooltip((Component[])Arrays.stream(this.getTooltip()).map(Component::literal).toArray(Component[]::new)).setDefaultValue((String)this.getDefaultValue()).build();
            }
        };
    }

    private Entry(String name, Supplier<T> current, Consumer<T> saver, T defaultValue, String ... tooltip) {
        this(name, (Supplier<Object>)current, (Consumer<Object>)saver, defaultValue, null, null, tooltip);
    }

    private Entry(String name, Supplier<T> current, Consumer<T> saver, T defaultValue, T min, T max, String ... tooltip) {
        this.text = name;
        this.current = current;
        this.saver = saver;
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.tooltip = tooltip;
    }

    abstract TooltipListEntry<T> build(ConfigEntryBuilder var1);

    public String getText() {
        return this.text;
    }

    public String[] getTooltip() {
        return this.tooltip;
    }

    public Supplier<T> getCurrent() {
        return this.current;
    }

    public Consumer<T> getSaver() {
        return this.saver;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }
}

