/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity.compat;

import java.util.Objects;
import net.hecco.bountifulfares.block.custom.compat.CabinetBlock;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public class CabinetBlockEntity
extends RandomizableContainerBlockEntity {
    private static final int MAX_INVENTORY_SIZE = 27;
    private final ContainerOpenersCounter viewerManager;
    private NonNullList<ItemStack> content = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);

    public CabinetBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BFBlockEntities.CABINET_BLOCK_ENTITY, blockPos, blockState);
    }

    private CabinetBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.viewerManager = new ContainerOpenersCounter(){

            protected void onOpen(Level world, BlockPos pos, BlockState state) {
                world.playSound(null, pos, BFSounds.CABINET_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                CabinetBlockEntity.this.setOpen(state, true);
            }

            protected void onClose(Level world, BlockPos pos, BlockState state) {
                CabinetBlockEntity.this.playSound(state, BFSounds.CABINET_OPEN);
                CabinetBlockEntity.this.setOpen(state, false);
            }

            protected void openerCountChanged(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
            }

            protected boolean isOwnContainer(Player player) {
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof ChestMenu) {
                    ChestMenu genericContainerScreenHandler = (ChestMenu)abstractContainerMenu;
                    Container inventory = genericContainerScreenHandler.getContainer();
                    return inventory == CabinetBlockEntity.this;
                }
                return false;
            }
        };
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"farmersdelight.container.cabinet");
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.content;
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.content = list;
    }

    public int getContainerSize() {
        return 27;
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.viewerManager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.viewerManager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.content);
        }
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.content = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.content);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbtCompound = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)nbtCompound, this.content, (boolean)true);
        return nbtCompound;
    }

    public void tick() {
        if (!this.remove) {
            this.viewerManager.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
        if (this.viewerManager.getOpenerCount() > 0) {
            this.scheduleTick();
        } else {
            BlockState blockstate = this.getBlockState();
            if (!(blockstate.getBlock() instanceof CabinetBlock)) {
                this.setRemoved();
                return;
            }
            boolean flag = (Boolean)blockstate.getValue((Property)CabinetBlock.OPEN);
            if (flag) {
                this.playSound(blockstate, SoundEvents.BARREL_CLOSE);
                this.setOpen(blockstate, false);
            }
        }
    }

    private void scheduleTick() {
        Objects.requireNonNull(this.getLevel()).getBlockTicks().schedule(ScheduledTick.probe((Object)this.getBlockState().getBlock(), (BlockPos)this.getBlockPos()));
    }

    private void setOpen(BlockState state, boolean open) {
        Objects.requireNonNull(this.getLevel()).setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)CabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)));
    }

    private void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.getValue((Property)CabinetBlock.FACING)).getNormal();
        BlockPos pos = this.getBlockPos();
        double dX = (double)pos.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double dT = (double)pos.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double dZ = (double)pos.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        Level world = Objects.requireNonNull(this.getLevel());
        world.playSound(null, dX, dT, dZ, sound, SoundSource.BLOCKS, 0.5f, world.getRandom().nextFloat() * 0.1f + 0.9f);
    }
}

