/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity;

import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.block.custom.GristmillBlock;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.ImplementedInventory;
import net.hecco.bountifulfares.recipe.MillingRecipe;
import net.hecco.bountifulfares.screen.GristmillScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GristmillBlockEntity
extends BlockEntity
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private static BooleanProperty millingState;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private static final int[] TOP_SLOTS;
    private static final int[] BOTTOM_SLOTS;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData propertyDelegate;
    private int progress = 0;
    private int maxProgress = 80;

    public GristmillBlockEntity(BlockPos pos, BlockState state) {
        super(BFBlockEntities.GRISTMILL_BLOCK_ENTITY, pos, state);
        millingState = ((GristmillBlock)state.getBlock()).getMillingState();
        this.propertyDelegate = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> GristmillBlockEntity.this.progress;
                    case 1 -> GristmillBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        GristmillBlockEntity.this.progress = value;
                    }
                    case 1: {
                        GristmillBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
        buf.writeBlockPos(this.worldPosition);
    }

    public Component method_5476() {
        return Component.translatable((String)"block.bountifulfares.gristmill");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new GristmillScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory);
        nbt.putInt("milling.progress", this.progress);
    }

    public void load(CompoundTag nbt) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory);
        nbt.getInt("milling.progress");
        super.load(nbt);
    }

    private boolean isCrafting() {
        return this.hasRecipe() && this.canInsertOutputSlot();
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (!world.isClientSide) {
            if (this.maxProgress != BountifulFares.CONFIG.getMillingTime() * 20) {
                this.maxProgress = BountifulFares.CONFIG.getMillingTime() * 20;
            }
            if (!((Boolean)state.getValue((Property)millingState)).booleanValue() && !((ItemStack)this.inventory.get(0)).isEmpty() && this.isCrafting()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)millingState, (Comparable)Boolean.valueOf(true)));
            }
            if (((Boolean)state.getValue((Property)millingState)).booleanValue() && !this.hasRecipe() && this.progress != 0) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)millingState, (Comparable)Boolean.valueOf(false)));
            }
            if (this.canInsertOutputSlot() && this.hasRecipe()) {
                this.increaseCraftingProgress();
                GristmillBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
                if (this.hasCraftingFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.decreaseCraftingProgress();
            }
        }
    }

    private void resetProgress() {
        this.progress = 1;
    }

    private void craftItem() {
        Optional<MillingRecipe> recipe = this.getCurrentRecipe();
        this.removeItem(0, 1);
        this.setItem(1, new ItemStack((ItemLike)recipe.get().getResultItem(null).getItem(), this.getItem(1).getCount() + recipe.get().getResultItem(null).getCount()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void decreaseCraftingProgress() {
        if (this.progress > 0) {
            this.progress -= 2;
        }
    }

    private boolean hasRecipe() {
        Optional<MillingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = recipe.get().getResultItem(null);
        return this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.getItem(1).isEmpty() || this.getItem(1).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.getItem(1).getMaxStackSize() >= this.getItem(1).getCount() + count;
    }

    @Override
    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return TOP_SLOTS;
    }

    private Optional<MillingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.getContainerSize());
        for (int i = 0; i < this.getContainerSize(); ++i) {
            inventory.setItem(i, this.getItem(i));
        }
        return this.getLevel().getRecipeManager().getRecipeFor((RecipeType)MillingRecipe.Type.INSTANCE, (Container)inventory, this.getLevel());
    }

    private boolean canInsertOutputSlot() {
        return this.getItem(1).isEmpty() || this.getItem(1).getCount() < this.getItem(1).getMaxStackSize();
    }

    static {
        TOP_SLOTS = new int[]{0};
        BOTTOM_SLOTS = new int[]{1};
    }
}

