/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity;

import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.block.custom.FermentationVesselBlock;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.ImplementedInventory;
import net.hecco.bountifulfares.block.enums.FermentationStage;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.hecco.bountifulfares.util.FermentationRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FermentationVesselBlockEntity
extends BlockEntity
implements ImplementedInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> FermentationVesselBlockEntity.this.progress;
                case 1 -> FermentationVesselBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    FermentationVesselBlockEntity.this.progress = value;
                }
                case 1: {
                    FermentationVesselBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 1;
        }
    };
    private int progress = 0;
    private int maxProgress;
    public boolean fermented = false;

    public FermentationVesselBlockEntity(BlockPos pos, BlockState state) {
        super(BFBlockEntities.FERMENTATION_VESSEL_BLOCK_ENTITY, pos, state);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory);
        nbt.putInt("fermenting.progress", this.progress);
    }

    public void load(CompoundTag nbt) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory);
        nbt.getInt("fermenting.progress");
        super.load(nbt);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public boolean canInsertItem() {
        return this.getItem(0).isEmpty();
    }

    public void insertItem(ItemStack item) {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.setItem(0, item.copyWithCount(1));
            this.setChanged();
        }
    }

    public void removeItem() {
        assert (this.level != null);
        this.setItem(0, Items.AIR.getDefaultInstance());
        this.setChanged();
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (!world.isClientSide) {
            if (this.maxProgress != BountifulFares.CONFIG.getFermentationTime() * 20) {
                this.maxProgress = BountifulFares.CONFIG.getFermentationTime() * 20;
            }
            if (this.progress < this.maxProgress && !((ItemStack)this.inventory.get(0)).isEmpty()) {
                ++this.progress;
                FermentationVesselBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            }
            if (this.progress >= this.maxProgress && ((ItemStack)this.inventory.get(0)).isEmpty()) {
                this.fermented = false;
                this.progress = 0;
                FermentationVesselBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            }
            if (!this.fermented && this.progress >= this.maxProgress && !((ItemStack)this.inventory.get(0)).isEmpty() && state.getValue(FermentationVesselBlock.FERMENTATION_STAGE) != FermentationStage.FERMENTED) {
                this.fermented = true;
                BountifulFares.LOGGER.info("changed" + this.progress + " " + this.maxProgress);
                world.playSound(null, pos, BFSounds.FERMENTATION_VESSEL_FERMENT, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
                FermentationVesselBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            }
            if (this.fermented && state.getValue(FermentationVesselBlock.FERMENTATION_STAGE) != FermentationStage.FERMENTED) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(FermentationVesselBlock.FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.FERMENTED)));
            }
        }
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
        return false;
    }

    @Override
    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return false;
    }

    public InteractionResult tryExtractItem(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        if (this.fermented) {
            ItemStack input = (ItemStack)this.inventory.get(0);
            Item output = FermentationRecipes.getOutputFromInput(input.getItem());
            Item collector = null;
            if (output != null) {
                collector = FermentationRecipes.getCollector(output);
            }
            if (collector == null) {
                Integer outputCount = FermentationRecipes.getOutputCount(output);
                FermentationVesselBlock.popResource((Level)world, (BlockPos)new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ()), (ItemStack)new ItemStack((ItemLike)output, outputCount.intValue()));
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(FermentationVesselBlock.FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.EMPTY)));
                this.removeItem();
                world.playSound(null, pos, BFSounds.FERMENTATION_VESSEL_EMPTY, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
                this.progress = 0;
                this.fermented = false;
                FermentationVesselBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(hand).is(collector)) {
                world.playSound(null, pos, BFSounds.FERMENTATION_VESSEL_EMPTY, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
                if (!player.isCreative()) {
                    player.getItemInHand(hand).shrink(1);
                }
                if (player.getItemInHand(hand).isEmpty() && !player.isCreative()) {
                    player.setItemInHand(hand, new ItemStack((ItemLike)output));
                } else if (!player.getInventory().add(new ItemStack((ItemLike)output))) {
                    player.drop(new ItemStack((ItemLike)output), false);
                }
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(FermentationVesselBlock.FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.EMPTY)));
                this.progress = 0;
                this.fermented = false;
                this.removeItem();
                FermentationVesselBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)("warning.bountifulfares.fermentation_vessel." + String.valueOf(collector))), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

