/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom.compat;

import net.hecco.bountifulfares.util.BFBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TwigsTableBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final BooleanProperty LEG1 = BooleanProperty.create((String)"table_leg1");
    private static final BooleanProperty LEG2 = BooleanProperty.create((String)"table_leg2");
    private static final BooleanProperty LEG3 = BooleanProperty.create((String)"table_leg3");
    private static final BooleanProperty LEG4 = BooleanProperty.create((String)"table_leg4");
    public static final BooleanProperty UPDATE = BooleanProperty.create((String)"update");
    protected static final VoxelShape TOP = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_1 = Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0);
    protected static final VoxelShape LEG_2 = Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0);
    protected static final VoxelShape LEG_3 = Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0);
    protected static final VoxelShape LEG_4 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{TOP, Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_1), Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_2), Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_3), Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_4), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_3, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3, LEG_4})};

    public TwigsTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEG1, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Boolean leg1 = (Boolean)state.getValue((Property)LEG1);
        Boolean leg2 = (Boolean)state.getValue((Property)LEG2);
        Boolean leg3 = (Boolean)state.getValue((Property)LEG3);
        Boolean leg4 = (Boolean)state.getValue((Property)LEG4);
        int shape = 0;
        if (leg2.booleanValue()) {
            shape = 1;
        }
        if (leg3.booleanValue()) {
            shape = 2;
        }
        if (leg1.booleanValue()) {
            shape = 3;
        }
        if (leg4.booleanValue()) {
            shape = 4;
        }
        if (leg2.booleanValue() && leg3.booleanValue()) {
            shape = 5;
        }
        if (leg2.booleanValue() && leg1.booleanValue()) {
            shape = 6;
        }
        if (leg2.booleanValue() && leg4.booleanValue()) {
            shape = 7;
        }
        if (leg3.booleanValue() && leg1.booleanValue()) {
            shape = 8;
        }
        if (leg3.booleanValue() && leg4.booleanValue()) {
            shape = 9;
        }
        if (leg1.booleanValue() && leg4.booleanValue()) {
            shape = 10;
        }
        if (leg2.booleanValue() && leg3.booleanValue() && leg1.booleanValue()) {
            shape = 11;
        }
        if (leg2.booleanValue() && leg3.booleanValue() && leg4.booleanValue()) {
            shape = 12;
        }
        if (leg2.booleanValue() && leg1.booleanValue() && leg4.booleanValue()) {
            shape = 13;
        }
        if (leg3.booleanValue() && leg1.booleanValue() && leg4.booleanValue()) {
            shape = 14;
        }
        if (leg2.booleanValue() && leg3.booleanValue() && leg1.booleanValue() && leg4.booleanValue()) {
            shape = 15;
        }
        return SHAPES[shape];
    }

    public BlockState getConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = this.canConnect(level.getBlockState(pos.north()));
        boolean south = this.canConnect(level.getBlockState(pos.south()));
        boolean east = this.canConnect(level.getBlockState(pos.east()));
        boolean west = this.canConnect(level.getBlockState(pos.west()));
        boolean update = ((north ? 1 : 0) + (east ? 1 : 0) + (south ? 1 : 0) + (west ? 1 : 0)) % 2 == 0;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)LEG1, (Comparable)Boolean.valueOf(!north && !east || north && east && !this.canConnect(level.getBlockState(pos.north().east()))))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(!east && !south || east && south && !this.canConnect(level.getBlockState(pos.south().east()))))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(!west && !south || west && south && !this.canConnect(level.getBlockState(pos.south().west()))))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(!west && !north || west && north && !this.canConnect(level.getBlockState(pos.north().west()))))).setValue((Property)UPDATE, (Comparable)Boolean.valueOf(update));
    }

    public boolean canConnect(BlockState state) {
        return state.is(BFBlockTags.TABLES);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getConnections((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.getConnections(state, level, currentPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, UPDATE, LEG1, LEG2, LEG3, LEG4});
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

