/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom.compat;

import net.hecco.bountifulfares.block.custom.compat.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallDoorBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<TripleBlockPart> THIRD = EnumProperty.create((String)"third", TripleBlockPart.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final BlockSetType type;

    public TallDoorBlock(Block from, BlockSetType blockset) {
        this(from, blockset, null);
    }

    public TallDoorBlock(Block from, BlockSetType blockset, @Nullable FeatureFlag flag) {
        super(flag != null ? BlockBehaviour.Properties.copy((BlockBehaviour)from).requiredFeatures(new FeatureFlag[]{flag}) : BlockBehaviour.Properties.copy((BlockBehaviour)from));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue(THIRD, (Comparable)((Object)TripleBlockPart.LOWER)));
        this.type = blockset;
    }

    public TallDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockset) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue(THIRD, (Comparable)((Object)TripleBlockPart.LOWER)));
        this.type = blockset;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)stateIn.getValue(THIRD));
        if (facing.getAxis() != Direction.Axis.Y || tripleblockpart == TripleBlockPart.LOWER != (facing == Direction.UP) && tripleblockpart != TripleBlockPart.MIDDLE) {
            return tripleblockpart == TripleBlockPart.LOWER && facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
        }
        return facingState.getBlock() == this && facingState.getValue(THIRD) != tripleblockpart ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)FACING, (Comparable)((Direction)facingState.getValue((Property)FACING)))).setValue((Property)OPEN, (Comparable)((Boolean)facingState.getValue((Property)OPEN)))).setValue(HINGE, (Comparable)((DoorHingeSide)facingState.getValue(HINGE)))).setValue((Property)POWERED, (Comparable)((Boolean)facingState.getValue((Property)POWERED))) : Blocks.AIR.defaultBlockState();
    }

    public void playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && player.isCreative()) {
            BlockPos otherPos1 = pos;
            BlockPos otherPos2 = pos;
            TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)state.getValue(THIRD));
            switch (tripleblockpart) {
                case LOWER: {
                    otherPos1 = pos.above();
                    otherPos2 = pos.above(2);
                    break;
                }
                case MIDDLE: {
                    otherPos1 = pos.below();
                    otherPos2 = pos.above();
                    break;
                }
                case UPPER: {
                    otherPos1 = pos.below(2);
                    otherPos2 = pos.below();
                }
            }
            BlockState blockstate1 = level.getBlockState(otherPos1);
            BlockState blockstate2 = level.getBlockState(otherPos2);
            if (blockstate1.getBlock() == state.getBlock() && blockstate1.getValue(THIRD) == TripleBlockPart.LOWER) {
                level.setBlock(otherPos1, (Boolean)blockstate1.getValue((Property)WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(player, 2001, otherPos1, Block.getId((BlockState)blockstate1));
            }
            if (blockstate2.getBlock() == state.getBlock() && blockstate2.getValue(THIRD) == TripleBlockPart.LOWER) {
                level.setBlock(otherPos2, (Boolean)blockstate2.getValue((Property)WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(player, 2001, otherPos1, Block.getId((BlockState)blockstate1));
            }
        }
        super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        if (blockpos.getY() < context.getLevel().getMaxBuildHeight() - 2 && context.getLevel().getBlockState(blockpos.above()).canBeReplaced(context) && context.getLevel().getBlockState(blockpos.above(2)).canBeReplaced(context)) {
            Level level = context.getLevel();
            boolean flag = level.hasNeighborSignal(blockpos) || level.hasNeighborSignal(blockpos.above());
            boolean waterfilled = level.getFluidState(blockpos).getType() == Fluids.WATER;
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HINGE, (Comparable)this.getHinge(context))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag))).setValue(THIRD, (Comparable)((Object)TripleBlockPart.LOWER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        boolean waterfilled = level.getFluidState(pos.above(1)).getType() == Fluids.WATER;
        boolean waterfilled2 = level.getFluidState(pos.above(2)).getType() == Fluids.WATER;
        level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue(THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled)), 3);
        level.setBlock(pos.above().above(), (BlockState)((BlockState)state.setValue(THIRD, (Comparable)((Object)TripleBlockPart.UPPER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled2)), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        boolean rightIsLowerOfSameType;
        Level BlockGetter2 = context.getLevel();
        BlockPos placePos = context.getClickedPos();
        Direction behindDir = context.getHorizontalDirection();
        BlockPos placePosAbove = placePos.above();
        Direction leftDir = behindDir.getCounterClockWise();
        BlockPos leftPos = placePos.relative(leftDir);
        BlockState leftBlockstate = BlockGetter2.getBlockState(leftPos);
        BlockPos leftPosAbove = placePosAbove.relative(leftDir);
        BlockState leftAboveBlockstate = BlockGetter2.getBlockState(leftPosAbove);
        Direction rightDir = behindDir.getClockWise();
        BlockPos rightPos = placePos.relative(rightDir);
        BlockState rightBlockstate = BlockGetter2.getBlockState(rightPos);
        BlockPos rightPosAbove = placePosAbove.relative(rightDir);
        BlockState rightAboveBlockstate = BlockGetter2.getBlockState(rightPosAbove);
        int i = (leftBlockstate.isCollisionShapeFullBlock((BlockGetter)BlockGetter2, leftPos) ? -1 : 0) + (leftAboveBlockstate.isCollisionShapeFullBlock((BlockGetter)BlockGetter2, leftPosAbove) ? -1 : 0) + (rightBlockstate.isCollisionShapeFullBlock((BlockGetter)BlockGetter2, rightPos) ? 1 : 0) + (rightAboveBlockstate.isCollisionShapeFullBlock((BlockGetter)BlockGetter2, rightPosAbove) ? 1 : 0);
        boolean leftIsLowerOfSameType = leftBlockstate.getBlock() == this && leftBlockstate.getValue(THIRD) == TripleBlockPart.LOWER;
        boolean bl = rightIsLowerOfSameType = rightBlockstate.getBlock() == this && rightBlockstate.getValue(THIRD) == TripleBlockPart.LOWER;
        if ((!leftIsLowerOfSameType || rightIsLowerOfSameType) && i <= 0) {
            if ((!rightIsLowerOfSameType || leftIsLowerOfSameType) && i >= 0) {
                int j = behindDir.getStepX();
                int k = behindDir.getStepZ();
                Vec3 vec3d = context.getClickLocation();
                double d0 = vec3d.x - (double)placePos.getX();
                double d1 = vec3d.z - (double)placePos.getZ();
                return j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 10);
        this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
        level.gameEvent((Entity)player, (Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void toggleDoor(Level level, BlockPos pos, boolean open) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.getBlock() == this && (Boolean)blockstate.getValue((Property)OPEN) != open) {
            level.setBlock(pos, (BlockState)blockstate.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            if (blockstate.getValue(THIRD) == TripleBlockPart.UPPER) {
                BlockState middle = level.getBlockState(pos.below());
                BlockState bottom = level.getBlockState(pos.below(2));
                if (middle.getBlock() == this) {
                    level.setBlock(pos.below(), (BlockState)middle.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
                }
                if (bottom.getBlock() == this) {
                    level.setBlock(pos.below(2), (BlockState)middle.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
                }
            }
            this.playSound(null, level, pos, open);
        }
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != open) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(entity, level, pos, open);
            level.gameEvent(entity, open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, pos);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.hasNeighborSignal(pos);
        if (!flag) {
            switch ((TripleBlockPart)((Object)state.getValue(THIRD))) {
                case LOWER: {
                    flag = level.hasNeighborSignal(pos.relative(Direction.UP)) || level.hasNeighborSignal(pos.relative(Direction.UP, 2));
                    break;
                }
                case MIDDLE: {
                    flag = level.hasNeighborSignal(pos.relative(Direction.DOWN)) || level.hasNeighborSignal(pos.relative(Direction.UP));
                    break;
                }
                case UPPER: {
                    boolean bl = flag = level.hasNeighborSignal(pos.relative(Direction.DOWN)) || level.hasNeighborSignal(pos.relative(Direction.DOWN, 2));
                }
            }
        }
        if (blockIn != this && flag != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockPos below2 = below.below();
        BlockState belowState = level.getBlockState(below);
        BlockState below2State = level.getBlockState(below2);
        if (state.getValue(THIRD) == TripleBlockPart.LOWER) {
            boolean result = belowState.isFaceSturdy((BlockGetter)level, below, Direction.UP);
            return result;
        }
        if (state.getValue(THIRD) == TripleBlockPart.MIDDLE) {
            boolean result = belowState.getBlock() == this;
            return result;
        }
        boolean result = belowState.getBlock() == this && below2State.getBlock() == this;
        return result;
    }

    protected void playSound(@Nullable Entity entity, Level level, BlockPos pos, boolean isOpen) {
        level.playSound(entity, pos, isOpen ? this.type.doorOpen() : this.type.doorClose(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(THIRD) == TripleBlockPart.LOWER ? 0 : (state.getValue(THIRD) == TripleBlockPart.MIDDLE ? 1 : 2)).getY(), (int)pos.getZ());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{THIRD, FACING, OPEN, HINGE, POWERED, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        boolean flag = (Boolean)state.getValue((Property)OPEN) == false;
        boolean flag1 = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean allowsMovement(BlockState state, BlockGetter level, BlockPos pos, BlockPathTypes type) {
        return switch (type) {
            case BlockPathTypes.WALKABLE, BlockPathTypes.OPEN -> (Boolean)state.getValue((Property)OPEN);
            default -> false;
        };
    }

    public PushReaction getPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING))).cycle(HINGE);
    }

    public static boolean isWoodenDoor(Level level, BlockPos pos) {
        return TallDoorBlock.isWoodenDoor(level.getBlockState(pos));
    }

    public static boolean isWoodenDoor(BlockState state) {
        return state.getBlock() instanceof TallDoorBlock;
    }

    public BlockSetType type() {
        return this.type;
    }
}

