/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom.compat;

import net.hecco.bountifulfares.block.custom.compat.TallDoorBlock;
import net.hecco.bountifulfares.block.custom.compat.TripleBlockPart;
import net.hecco.bountifulfares.block.entity.DyeableCeramicBlockEntity;
import net.hecco.bountifulfares.block.interfaces.DyeableCeramicBlockInterface;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.item.custom.DyeableCeramicBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TallCeramicDoorBlock
extends TallDoorBlock
implements DyeableCeramicBlockInterface {
    private final BlockSetType blockSetType;

    public TallCeramicDoorBlock(BlockBehaviour.Properties settings, BlockSetType blockSetType) {
        super(settings, blockSetType);
        this.blockSetType = blockSetType;
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        if (DyeableCeramicBlockEntity.getColor(world, pos) != 0xFFFFFF) {
            ItemStack stack = super.getCloneItemStack(world, pos, state);
            return this.pickBlock(world, pos, stack);
        }
        return new ItemStack((ItemLike)this);
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(BFItems.ARTISAN_BRUSH) && !player.isShiftKeyDown() && itemStack.getTagElement("display") != null) {
            DyeableCeramicBlockEntity dyeableCeramicBlockEntity;
            BlockEntity blockEntity;
            int brushColor = itemStack.getTagElement("display").getInt("color");
            if (state.getValue((Property)THIRD) == TripleBlockPart.LOWER && world.getBlockState(pos.above()).is((Block)this) && world.getBlockState(pos.above(2)).is((Block)this)) {
                world.setBlock(pos.above(), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE)), 0);
                blockEntity = world.getBlockEntity(pos.above());
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
                world.setBlock(pos.above(2), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.UPPER)), 0);
                blockEntity = world.getBlockEntity(pos.above(2));
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
            }
            if (state.getValue((Property)THIRD) == TripleBlockPart.MIDDLE && world.getBlockState(pos.above()).is((Block)this) && world.getBlockState(pos.below()).is((Block)this)) {
                world.setBlock(pos.above(), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.UPPER)), 0);
                blockEntity = world.getBlockEntity(pos.above());
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
                world.setBlock(pos.below(), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER)), 0);
                blockEntity = world.getBlockEntity(pos.below());
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
            }
            if (state.getValue((Property)THIRD) == TripleBlockPart.UPPER && world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.below(2)).is((Block)this)) {
                world.setBlock(pos.below(), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE)), 0);
                blockEntity = world.getBlockEntity(pos.below());
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
                world.setBlock(pos.below(2), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER)), 0);
                blockEntity = world.getBlockEntity(pos.below(2));
                if (blockEntity instanceof DyeableCeramicBlockEntity) {
                    dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                    if (dyeableCeramicBlockEntity.color != brushColor) {
                        dyeableCeramicBlockEntity.color = brushColor;
                        dyeableCeramicBlockEntity.setChanged();
                    }
                }
            }
            world.removeBlock(pos, false);
            world.setBlock(pos, this.withPropertiesOf(state), 0);
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
            blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DyeableCeramicBlockEntity) {
                dyeableCeramicBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                if (dyeableCeramicBlockEntity.color != brushColor) {
                    dyeableCeramicBlockEntity.color = brushColor;
                    dyeableCeramicBlockEntity.setChanged();
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (!this.blockSetType.canOpenByHand()) {
                return InteractionResult.PASS;
            }
            state = (BlockState)state.cycle((Property)OPEN);
            world.setBlock(pos, state, 10);
            this.playOpenCloseSound((Entity)player, world, pos, (Boolean)state.getValue((Property)OPEN));
            world.gameEvent((Entity)player, this.isOpen(state) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, pos);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DyeableCeramicBlockEntity bottomEntity;
        DyeableCeramicBlockEntity middleEntity;
        TripleBlockPart tripleBlockPart = (TripleBlockPart)((Object)state.getValue((Property)THIRD));
        DyeableCeramicBlockEntity entity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos);
        if (tripleBlockPart == TripleBlockPart.LOWER) {
            middleEntity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.above());
            DyeableCeramicBlockEntity topEntity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.above(2));
            if (world.getBlockState(pos.above()).is((Block)this) && world.getBlockState(pos.above(2)).is((Block)this) && entity.color == middleEntity.color && entity.color == topEntity.color) {
                return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            }
        }
        if (tripleBlockPart == TripleBlockPart.MIDDLE) {
            DyeableCeramicBlockEntity topEntity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.above());
            bottomEntity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.below());
            if (world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.above()).is((Block)this) && entity.color == topEntity.color && entity.color == bottomEntity.color) {
                return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            }
        }
        if (tripleBlockPart == TripleBlockPart.UPPER) {
            middleEntity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.below());
            bottomEntity = (DyeableCeramicBlockEntity)world.getBlockEntity(pos.below(2));
            if (world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.below(2)).is((Block)this) && entity.color == middleEntity.color && entity.color == bottomEntity.color) {
                return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            }
        }
        return state;
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean bl;
        boolean bl2 = world.hasNeighborSignal(pos) || state.getValue((Property)THIRD) == TripleBlockPart.LOWER ? world.hasNeighborSignal(pos.above()) || world.hasNeighborSignal(pos.above(2)) : (state.getValue((Property)THIRD) == TripleBlockPart.MIDDLE ? world.hasNeighborSignal(pos.above()) || world.hasNeighborSignal(pos.below()) : (bl = world.hasNeighborSignal(pos.below()) || world.hasNeighborSignal(pos.below(2))));
        if (!this.defaultBlockState().is(sourceBlock) && bl != (Boolean)state.getValue((Property)POWERED) && bl != (Boolean)state.getValue((Property)POWERED)) {
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                state = (BlockState)state.cycle((Property)OPEN);
                this.playOpenCloseSound(null, world, pos, bl);
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    private void playOpenCloseSound(@Nullable Entity entity, Level world, BlockPos pos, boolean open) {
        world.playSound(entity, pos, open ? this.blockSetType.doorOpen() : this.blockSetType.doorClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        DyeableCeramicBlockItem thisEntity;
        DyeableCeramicBlockEntity entity;
        world.setBlock(pos.above(), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE)), 3);
        BlockEntity blockEntity = world.getBlockEntity(pos.above());
        if (blockEntity instanceof DyeableCeramicBlockEntity) {
            entity = (DyeableCeramicBlockEntity)blockEntity;
            thisEntity = (DyeableCeramicBlockItem)itemStack.getItem();
            entity.color = thisEntity.getColor(itemStack);
            entity.setChanged();
        }
        world.setBlock(pos.above(2), (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.UPPER)), 3);
        thisEntity = world.getBlockEntity(pos.above(2));
        if (thisEntity instanceof DyeableCeramicBlockEntity) {
            entity = (DyeableCeramicBlockEntity)((Object)thisEntity);
            thisEntity = (DyeableCeramicBlockItem)itemStack.getItem();
            entity.color = thisEntity.getColor(itemStack);
            entity.setChanged();
        }
    }

    @Override
    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.getValue((Property)THIRD) == TripleBlockPart.LOWER && world.getBlockState(pos.above()).is((Block)this) && world.getBlockState(pos.above(2)).is((Block)this)) {
            world.scheduleTick(pos.above(), (Block)this, 1);
            world.scheduleTick(pos.above(2), (Block)this, 1);
        }
        if (state.getValue((Property)THIRD) == TripleBlockPart.MIDDLE && world.getBlockState(pos.above()).is((Block)this)) {
            world.scheduleTick(pos.above(), (Block)this, 1);
        }
        if (state.getValue((Property)THIRD) == TripleBlockPart.UPPER && world.getBlockState(pos.below()).is((Block)this)) {
            world.scheduleTick(pos.below(), (Block)this, 1);
        }
        super.playerWillDestroy(world, pos, state, player);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.destroyBlock(pos, true);
        super.tick(state, world, pos, random);
    }
}

