/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.item.BFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeaShrubBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static BooleanProperty BERRIES = BooleanProperty.create((String)"berries");
    private static final VoxelShape AGE0_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape AGE1_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    private static final VoxelShape AGE2_SHAPE = Shapes.join((VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.getValue((Property)AGE)) {
            case 0: {
                return AGE0_SHAPE;
            }
            case 1: {
                return AGE1_SHAPE;
            }
        }
        return AGE2_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) >= 2 && context.isAbove(AGE2_SHAPE, pos, false)) {
            return AGE2_SHAPE;
        }
        return Shapes.empty();
    }

    public TeaShrubBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, BERRIES});
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!TeaShrubBlock.isFullyGrown(state) && random.nextFloat() < 0.5f) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS) && TeaShrubBlock.canHarvestLeaves(state)) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, playerx -> playerx.broadcastBreakEvent(hand));
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            if ((Integer)state.getValue((Property)AGE) == 4) {
                TeaShrubBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFItems.TEA_LEAVES, 2 + world.random.nextInt(3)));
            } else {
                TeaShrubBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFItems.TEA_LEAVES, 1 + world.random.nextInt(2)));
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.is(Items.BONE_MEAL) && (Integer)state.getValue((Property)AGE) == 4 && !((Boolean)state.getValue((Property)BERRIES)).booleanValue()) {
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.setBlock(pos, (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)BERRIES)).booleanValue()) {
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.setBlock(pos, (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)), 2);
            TeaShrubBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFItems.TEA_BERRIES, 1 + world.random.nextInt(1)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BFItems.TEA_BERRIES);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return !TeaShrubBlock.isFullyGrown(state);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!TeaShrubBlock.isFullyGrown(state)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    protected static boolean isFullyGrown(BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 4;
    }

    protected static boolean canHarvestLeaves(BlockState state) {
        return ((Integer)state.getValue((Property)AGE) == 3 || (Integer)state.getValue((Property)AGE) == 4) && (Boolean)state.getValue((Property)BERRIES) == false;
    }
}

