/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.item.BFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MaizeCropBlock
extends CropBlock
implements BonemealableBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF;
    public static final IntegerProperty AGE;
    public static final VoxelShape[] LOWER_SHAPES;
    public static final VoxelShape[] UPPER_SHAPES;

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return switch ((Integer)state.getValue((Property)AGE)) {
                case 0 -> LOWER_SHAPES[0];
                case 1 -> LOWER_SHAPES[1];
                case 2 -> LOWER_SHAPES[2];
                default -> LOWER_SHAPES[3];
            };
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return switch ((Integer)state.getValue((Property)AGE)) {
                case 0, 1, 2, 3, 4 -> UPPER_SHAPES[0];
                case 5 -> UPPER_SHAPES[1];
                default -> UPPER_SHAPES[2];
            };
        }
        return LOWER_SHAPES[3];
    }

    public MaizeCropBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    private boolean isFullyGrown(BlockState state) {
        return (Integer)state.getValue((Property)AGE) >= 7;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER && !this.isFullyGrown(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.defaultBlockState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : state;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (!MaizeCropBlock.isLowerHalf(state)) {
            return super.canSurvive(state, world, pos) || world.getBlockState(pos.below()).is((Block)this);
        }
        return super.mayPlaceOn(world.getBlockState(pos.below()), (BlockGetter)world, pos.below()) && MaizeCropBlock.canPlaceAt(world, pos) && ((Integer)state.getValue((Property)AGE) < 4 || MaizeCropBlock.isUpperHalf(world.getBlockState(pos.above())));
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BFItems.MAIZE_SEEDS);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, HALF});
    }

    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && (Integer)state.getValue((Property)AGE) < 7) {
            MaizeCropBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)BFItems.MAIZE_SEEDS.getDefaultInstance());
        }
        if (!world.isClientSide) {
            if (player.isCreative()) {
                MaizeCropBlock.onBreakInCreative(world, pos, state, player);
            } else {
                MaizeCropBlock.dropResources((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        super.playerWillDestroy(world, pos, state, player);
    }

    protected static void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState = world.getBlockState(blockPos = pos.below())).is(state.getBlock()) && blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState2 = blockState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            world.setBlock(blockPos, blockState2, 35);
            world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.getRawBrightness(pos, 0) >= 9) {
            boolean bl;
            float f = CropBlock.getGrowthSpeed((Block)this, (BlockGetter)world, (BlockPos)pos);
            boolean bl2 = bl = random.nextInt((int)(25.0f / f) + 1) == 0;
            if (bl) {
                this.tryGrow(world, state, pos);
            }
        }
    }

    private void tryGrow(ServerLevel world, BlockState state, BlockPos pos) {
        int i = Math.min((Integer)state.getValue((Property)AGE) + 1, 7);
        if (this.canGrow((LevelReader)world, pos, state, i)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
            if (i >= 4) {
                BlockPos blockPos = pos.above();
                world.setBlock(blockPos, MaizeCropBlock.withWaterloggedState((LevelReader)world, pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
            }
        }
    }

    private static boolean canGrowAt(LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isAir() || blockState.is(BFBlocks.MAIZE_CROP);
    }

    private static boolean canPlaceAt(LevelReader world, BlockPos pos) {
        return world.getRawBrightness(pos, 0) >= 8 || world.canSeeSky(pos);
    }

    private static boolean isLowerHalf(BlockState state) {
        return state.is(BFBlocks.MAIZE_CROP) && state.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    private static boolean isUpperHalf(BlockState state) {
        return state.is(BFBlocks.MAIZE_CROP) && state.getValue(HALF) == DoubleBlockHalf.UPPER;
    }

    private boolean canGrow(LevelReader world, BlockPos pos, BlockState state, int age) {
        return !this.isFullyGrown(state) && MaizeCropBlock.canPlaceAt(world, pos) && (age < 3 || MaizeCropBlock.canGrowAt(world, pos.above()));
    }

    @Nullable
    private LowerHalfContext getLowerHalfContext(LevelReader world, BlockPos pos, BlockState state) {
        if (MaizeCropBlock.isLowerHalf(state)) {
            return new LowerHalfContext(pos, state);
        }
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        return MaizeCropBlock.isLowerHalf(blockState) ? new LowerHalfContext(blockPos, blockState) : null;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext(world, pos, state);
        return lowerHalfContext != null && this.canGrow(world, lowerHalfContext.pos, lowerHalfContext.state, (Integer)lowerHalfContext.state.getValue((Property)AGE) + 1);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext((LevelReader)world, pos, state);
        if (lowerHalfContext != null) {
            this.tryGrow(world, lowerHalfContext.state, lowerHalfContext.pos);
        }
    }

    public static BlockState withWaterloggedState(LevelReader world, BlockPos pos, BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.isWaterAt(pos))) : state;
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(world, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, tool);
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    static {
        LOWER_SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
        UPPER_SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
        AGE = BlockStateProperties.AGE_7;
        HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    }

    private record LowerHalfContext(BlockPos pos, BlockState state) {
    }
}

